/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.Debug;

public class Mysql {
    private final Config config;
    private final Debug debug;
    private final String configsection;
    private Connection connection;

    public static void closeResultSet(AutoCloseable res) {
        if (res == null) {
            return;
        }
        try {
            res.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Mysql(Config c, Debug d, String configsection) {
        this.config = c;
        this.debug = d;
        this.configsection = configsection;
    }

    public void connect() {
        try {
            String url = "jdbc:mysql://" + this.config.getString(this.configsection + ".general.mysqlhost", "localhost") + ":" + this.config.getString(this.configsection + ".general.mysqlport", "3306") + "/" + this.config.getString(this.configsection + ".general.mysqldb", this.configsection) + "?autoReconnect=true&dontTrackOpenResources=true";
            this.connection = DriverManager.getConnection(url, this.config.getString(this.configsection + ".general.mysqluser", this.configsection), this.config.getString(this.configsection + ".general.mysqlpw", "password"));
        }
        catch (Exception e) {
            this.debug.log(e);
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                if (this.isConnected()) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.debug.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        ResultSet rs;
        boolean connected;
        block5: {
            connected = false;
            rs = null;
            try {
                rs = this.returnQuery("SELECT 1;", false);
                if (rs == null) {
                    connected = false;
                    break block5;
                }
                if (!rs.next()) break block5;
                connected = true;
            }
            catch (Exception e) {
                try {
                    connected = false;
                }
                catch (Throwable throwable) {
                    Mysql.closeResultSet(rs);
                    throw throwable;
                }
                Mysql.closeResultSet(rs);
            }
        }
        Mysql.closeResultSet(rs);
        return connected;
    }

    public ResultSet returnQuery(String query) {
        return this.returnQuery(query, true);
    }

    public boolean runQuery(String query) {
        return this.runQuery(query, true);
    }

    public long runQueryGetId(String query) {
        return this.runQueryGetId(query, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String table) {
        boolean tableexists = false;
        ResultSet res = null;
        try {
            res = this.returnQuery("SHOW TABLES");
            while (res.next()) {
                if (!res.getString(1).equalsIgnoreCase(table)) continue;
                tableexists = true;
                break;
            }
        }
        catch (Exception e) {
            this.debug.log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return tableexists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addColumn(String table, String column, String type, String after, String value) {
        boolean success = false;
        ResultSet res = null;
        try {
            String getc = "SHOW COLUMNS FROM " + table;
            res = this.returnQuery(getc);
            boolean found = false;
            while (res.next()) {
                if (!res.getString("Field").equalsIgnoreCase(column)) continue;
                found = true;
                break;
            }
            if (!found) {
                String c = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` " + type + " AFTER `" + after + "`";
                this.runQuery(c);
                c = "UPDATE " + table + " SET " + column + "=" + value;
                this.runQuery(c);
            }
            success = true;
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            this.debug.log(e);
            success = false;
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int columnExists(String table, String column) {
        int fsuccess = 2;
        ResultSet res = null;
        try {
            String getc = "SHOW COLUMNS FROM " + table;
            res = this.returnQuery(getc);
            while (res.next()) {
                if (!res.getString("Field").equalsIgnoreCase(column)) continue;
                fsuccess = 1;
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            this.debug.log(e);
            fsuccess = 0;
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return fsuccess;
    }

    private ResultSet returnQuery(String query, boolean checkconnection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (checkconnection) {
                this.checkConnection();
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
        }
        catch (SQLException e) {
            Mysql.closeResultSet(rs);
            Mysql.closeResultSet(stmt);
            throw new RuntimeException(e);
        }
        return rs;
    }

    private boolean runQuery(String query, boolean checkconnection) {
        try {
            boolean success;
            if (checkconnection) {
                this.checkConnection();
            }
            try (Statement stmt = this.connection.createStatement();){
                success = stmt.execute(query);
            }
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long runQueryGetId(String query, boolean checkconnection) {
        long id = 0L;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (checkconnection) {
                this.checkConnection();
            }
            stmt = this.connection.createStatement();
            stmt.executeUpdate(query, 1);
            rs = stmt.getGeneratedKeys();
            if (rs.last()) {
                id = rs.getLong(1);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Mysql.closeResultSet(rs);
                Mysql.closeResultSet(stmt);
                throw throwable;
            }
        }
        Mysql.closeResultSet(rs);
        Mysql.closeResultSet(stmt);
        return id;
    }

    private void checkConnection() {
        if (!this.isConnected()) {
            this.reconnect();
        }
    }

    private void reconnect() {
        this.close();
        this.connect();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        String ret = s;
        ret = ret.replaceAll("\\\\", "\\\\\\\\");
        ret = ret.replaceAll("\\n", "\\\\n");
        ret = ret.replaceAll("\\r", "\\\\r");
        ret = ret.replaceAll("\\t", "\\\\t");
        ret = ret.replaceAll("\\00", "\\\\0");
        ret = ret.replaceAll("'", "\\\\'");
        ret = ret.replaceAll("\\\"", "\\\\\"");
        return ret;
    }

    public static String unescape(String s) {
        if (s == null) {
            return null;
        }
        String ret = s;
        ret = ret.replaceAll("\\\\n", "\\n");
        ret = ret.replaceAll("\\\\r", "\\r");
        ret = ret.replaceAll("\\\\t", "\\t");
        ret = ret.replaceAll("\\\\0", "\\00");
        ret = ret.replaceAll("\\\\'", "'");
        ret = ret.replaceAll("\\\\\"", "\\\"");
        ret = ret.replaceAll("\\\\\\\\", "\\\\");
        return ret;
    }
}

