/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.alpenblock.bungeeperms.Mysql;
import net.alpenblock.bungeeperms.Statics;

public class MysqlConfig {
    private final Mysql mysql;
    private final String table;
    private final Map<String, List<String>> data;

    public MysqlConfig(Mysql m, String table) {
        this.mysql = m;
        this.table = table;
        this.data = new HashMap<String, List<String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.createTable();
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT `key`,`value` FROM `" + this.table + "` ORDER BY id ASC");
            this.fromResult(res);
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Mysql.closeResultSet(res);
        }
    }

    public void fromResult(ResultSet res) {
        try {
            while (res.next()) {
                String key = Mysql.unescape(res.getString("key"));
                String val = Mysql.unescape(res.getString("value"));
                List<String> values = this.data.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.data.put(key, values);
                }
                values.add(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createTable() {
        if (!this.mysql.tableExists(this.table)) {
            String t = "CREATE TABLE `" + this.table + "` (" + "`id` INT( 64 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ," + "`key` VARCHAR( 256 ) NOT NULL ," + "`value` VARCHAR( 256 ) NOT NULL " + ") ENGINE = MYISAM ;";
            this.mysql.runQuery(t);
        }
    }

    public String getString(String key, String def) {
        if (this.data.containsKey(key)) {
            return this.data.get(key).get(0);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(def);
        this.data.put(key, list);
        this.save(key, list);
        return def;
    }

    public int getInt(String key, int def) {
        if (this.data.containsKey(key)) {
            return Integer.parseInt(this.data.get(key).get(0));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(def));
        this.data.put(key, list);
        this.save(key, list);
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.data.containsKey(key)) {
            return Boolean.parseBoolean(this.data.get(key).get(0));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(def));
        this.data.put(key, list);
        this.save(key, list);
        return def;
    }

    public <T extends Enum> T getEnumValue(String key, T def) {
        if (this.data.containsKey(key)) {
            Enum[] constants;
            String s = this.getString(key, def.name());
            for (Enum constant : constants = (Enum[])def.getDeclaringClass().getEnumConstants()) {
                if (!constant.name().equals(s)) continue;
                return (T)constant;
            }
            return def;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(def.name());
        this.data.put(key, list);
        this.save(key, list);
        return def;
    }

    public List<String> getListString(String key, List<String> def) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        this.data.put(key, def);
        this.save(key, def);
        return def;
    }

    public double getDouble(String key, double def) {
        if (this.data.containsKey(key)) {
            return Double.parseDouble(this.data.get(key).get(0));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(def));
        this.data.put(key, list);
        this.save(key, list);
        return def;
    }

    public void setString(String key, String val) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(val);
        this.save(key, list);
    }

    public void setInt(String key, int val) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(val));
        this.save(key, list);
    }

    public void setBool(String key, boolean val) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(val));
        this.save(key, list);
    }

    public void setListString(String key, List<String> val) {
        this.save(key, val);
    }

    public List<String> getSubNodes(String node) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.data.keySet()) {
            String subnode;
            String rest;
            List<String> list;
            if (!this.isSubNode(node, key) || (list = Statics.toList(rest = key.substring(node.length() + 1), ".")).size() <= 0 || ret.contains(subnode = list.get(0))) continue;
            ret.add(subnode);
        }
        return ret;
    }

    private boolean isSubNode(String node, String subnode) {
        if (subnode.equals(node)) {
            return false;
        }
        if (!subnode.startsWith(node)) {
            return false;
        }
        String dotkeyrest = subnode.substring(node.length());
        return dotkeyrest.charAt(0) == '.';
    }

    public void deleteNode(String node) {
        for (String key : this.data.keySet()) {
            if (!this.isSubNode(key, node)) continue;
            this.data.remove(key);
            String delq = "DELETE FROM " + this.table + " WHERE `key`='" + key + "'";
            this.mysql.runQuery(delq);
        }
    }

    public boolean keyExists(String node) {
        return !this.getSubNodes(node).isEmpty();
    }

    private void save(String key, List<String> values) {
        String delq = "DELETE FROM `" + this.table + "` WHERE `key`='" + key + "'";
        this.mysql.runQuery(delq);
        for (String val : values) {
            String insq = "INSERT INTO `" + this.table + "` (`key`,`value`) VALUES('" + Mysql.escape(key) + "','" + Mysql.escape(val) + "')";
            this.mysql.runQuery(insq);
        }
    }

    public void clearTable(String table) {
        String q = "TRUNCATE `" + table + "`";
        this.mysql.runQuery(q);
    }
}

