/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.Sender;

public class PermissionsChecker {
    public boolean hasPerm(String sender, String permission) {
        User u = this.pm().getUser(sender);
        if (u == null) {
            return false;
        }
        return u.hasPerm(permission);
    }

    public boolean hasPermOnServer(String sender, String permission, String server) {
        User u = this.pm().getUser(sender);
        if (u == null) {
            return false;
        }
        if (server == null) {
            return this.hasPerm(sender, permission);
        }
        return u.hasPermOnServer(permission, server);
    }

    public boolean hasPermOnServerInWorld(String sender, String permission, String server, String world) {
        User u = this.pm().getUser(sender);
        if (u == null) {
            return false;
        }
        if (server == null) {
            return this.hasPerm(sender, permission);
        }
        if (world == null) {
            return this.hasPermOnServer(sender, permission, server);
        }
        return u.hasPermOnServerInWorld(permission, server, world);
    }

    public boolean hasPerm(Sender sender, String permission) {
        if (!sender.isConsole()) {
            User u = this.pm().getUser(sender.getName());
            if (u == null) {
                return false;
            }
            return u.hasPerm(sender, permission);
        }
        return false;
    }

    public boolean hasPermOrConsole(Sender sender, String permission) {
        if (sender.isConsole()) {
            return true;
        }
        User u = this.pm().getUser(sender.getName());
        if (u == null) {
            return false;
        }
        return u.hasPerm(sender, permission);
    }

    public boolean hasPermOnServer(Sender sender, String permission) {
        User u = this.pm().getUser(sender.getName());
        if (u == null) {
            return false;
        }
        if (sender.getServer() == null) {
            return this.hasPerm(sender, permission);
        }
        return u.hasPermOnServer(sender, permission, sender.getServer());
    }

    public boolean hasPermOrConsoleOnServer(Sender sender, String permission) {
        if (sender.isConsole()) {
            return true;
        }
        User u = this.pm().getUser(sender.getName());
        if (u == null) {
            return false;
        }
        if (sender.getServer() == null) {
            return this.hasPerm(sender, permission);
        }
        return u.hasPermOnServer(sender, permission, sender.getServer());
    }

    public boolean hasPermOnServerInWorld(Sender sender, String permission) {
        User u = this.pm().getUser(sender.getName());
        if (u == null) {
            return false;
        }
        if (sender.getServer() == null) {
            return this.hasPerm(sender, permission);
        }
        if (sender.getWorld() == null) {
            return this.hasPermOnServer(sender, permission);
        }
        return u.hasPermOnServerInWorld(sender, permission, sender.getServer(), sender.getWorld());
    }

    public boolean hasPermOrConsoleOnServerInWorld(Sender sender, String permission) {
        if (sender.isConsole()) {
            return true;
        }
        User u = this.pm().getUser(sender.getName());
        if (u == null) {
            return false;
        }
        if (sender.getServer() == null) {
            return this.hasPerm(sender, permission);
        }
        if (sender.getWorld() == null) {
            return this.hasPermOnServer(sender, permission);
        }
        return u.hasPermOnServerInWorld(sender, permission, sender.getServer(), sender.getWorld());
    }

    public boolean has(Sender sender, String perm, boolean msg) {
        if (sender.isPlayer()) {
            boolean isperm = this.hasPerm(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsole(Sender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPerm(sender, perm) || sender.isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    public boolean hasOnServer(Sender sender, String perm, boolean msg) {
        if (sender.isPlayer()) {
            boolean isperm = this.hasPermOnServer(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsoleOnServer(Sender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPermOnServer(sender, perm) || sender.isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    public boolean hasOnServerInWorld(Sender sender, String perm, boolean msg) {
        if (sender.isPlayer()) {
            boolean isperm = this.hasPermOnServerInWorld(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsoleOnServerInWorld(Sender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPermOnServerInWorld(sender, perm) || sender.isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    protected PermissionsManager pm() {
        return BungeePerms.getInstance().getPermissionsManager();
    }
}

