/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Debug;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.World;
import net.alpenblock.bungeeperms.io.BackEnd;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.MySQL2BackEnd;
import net.alpenblock.bungeeperms.io.MySQLBackEnd;
import net.alpenblock.bungeeperms.io.MySQLUUIDPlayerDB;
import net.alpenblock.bungeeperms.io.NoneUUIDPlayerDB;
import net.alpenblock.bungeeperms.io.UUIDPlayerDB;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;
import net.alpenblock.bungeeperms.io.YAMLBackEnd;
import net.alpenblock.bungeeperms.io.YAMLUUIDPlayerDB;
import net.alpenblock.bungeeperms.io.migrate.Migrate2MySQL;
import net.alpenblock.bungeeperms.io.migrate.Migrate2MySQL2;
import net.alpenblock.bungeeperms.io.migrate.Migrate2YAML;
import net.alpenblock.bungeeperms.io.migrate.Migrator;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.util.ConcurrentList;

public class PermissionsManager {
    private final PlatformPlugin plugin;
    private final BPConfig config;
    private final Debug debug;
    private boolean enabled = false;
    private BackEnd backEnd;
    private UUIDPlayerDB UUIDPlayerDB;
    private List<Group> groups;
    private List<User> users;
    private int permsversion;
    private final ReadWriteLock grouplock = new ReentrantReadWriteLock();
    private final ReadWriteLock userlock = new ReentrantReadWriteLock();

    public PermissionsManager(PlatformPlugin p, BPConfig conf, Debug d) {
        this.plugin = p;
        this.config = conf;
        this.debug = d;
        this.loadConfig();
        this.loadPerms();
    }

    public final void loadConfig() {
        this.config.load();
        BackEndType bet = this.config.getBackEndType();
        switch (bet) {
            case YAML: {
                this.backEnd = new YAMLBackEnd();
                break;
            }
            case MySQL: {
                this.backEnd = new MySQLBackEnd();
                break;
            }
            case MySQL2: {
                this.backEnd = new MySQL2BackEnd();
                break;
            }
        }
        UUIDPlayerDBType updbt = this.config.getUUIDPlayerDBType();
        switch (updbt) {
            case None: {
                this.UUIDPlayerDB = new NoneUUIDPlayerDB();
                break;
            }
            case YAML: {
                this.UUIDPlayerDB = new YAMLUUIDPlayerDB();
                break;
            }
            case MySQL: {
                this.UUIDPlayerDB = new MySQLUUIDPlayerDB();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadPerms() {
        BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.PERMISSIONS_LOADING, new Object[0]));
        this.backEnd.load();
        this.grouplock.writeLock().lock();
        try {
            this.groups = this.backEnd.loadGroups();
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
        this.userlock.writeLock().lock();
        try {
            this.users = new ConcurrentList<User>();
        }
        finally {
            this.userlock.writeLock().unlock();
        }
        this.permsversion = this.backEnd.loadVersion();
        BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.PERMISSIONS_LOADED, new Object[0]));
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        for (Sender s : BungeePerms.getInstance().getPlugin().getPlayers()) {
            User user;
            if (this.config.isUseUUIDs()) {
                user = this.getUser(s.getUUID());
                if (user == null) {
                    this.createTempUser(s.getName(), s.getUUID());
                }
            } else {
                user = this.getUser(s.getName());
                if (user == null) {
                    this.createTempUser(s.getName(), null);
                }
            }
            BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
        }
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.userlock.writeLock().lock();
        try {
            this.users.clear();
        }
        finally {
            this.userlock.writeLock().unlock();
        }
        this.enabled = false;
    }

    public void reload() {
        this.disable();
        this.loadConfig();
        this.loadPerms();
        this.enable();
        BungeePerms.getInstance().getEventDispatcher().dispatchReloadedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validateUsersGroups() {
        int j;
        this.grouplock.readLock().lock();
        try {
            for (Group group : this.groups) {
                List<String> inheritances = group.getInheritances();
                for (j = 0; j < inheritances.size(); ++j) {
                    if (this.getGroup(inheritances.get(j)) != null) continue;
                    inheritances.remove(j);
                    --j;
                }
                this.backEnd.saveGroupInheritances(group);
            }
            for (Group g : this.groups) {
                g.recalcPerms();
                BungeePerms.getInstance().getNetworkNotifier().reloadGroup(g, null);
            }
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        this.userlock.readLock().lock();
        try {
            for (User u : this.users) {
                for (int j2 = 0; j2 < u.getGroups().size(); ++j2) {
                    if (this.getGroup(u.getGroups().get(j2).getName()) != null) continue;
                    u.getGroups().remove(j2);
                    --j2;
                }
                this.backEnd.saveUserGroups(u);
            }
            for (User u : this.users) {
                u.recalcPerms();
                BungeePerms.getInstance().getNetworkNotifier().reloadUser(u, null);
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
        List<User> backendusers = this.backEnd.loadUsers();
        for (User u : backendusers) {
            for (j = 0; j < u.getGroups().size(); ++j) {
                if (this.getGroup(u.getGroups().get(j).getName()) != null) continue;
                u.getGroups().remove(j);
                --j;
            }
            this.backEnd.saveUserGroups(u);
        }
    }

    public synchronized Group getMainGroup(User player) {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        if (player.getGroups().isEmpty()) {
            return null;
        }
        Group ret = player.getGroups().get(0);
        for (int i = 1; i < player.getGroups().size(); ++i) {
            if (player.getGroups().get(i).getWeight() >= ret.getWeight()) continue;
            ret = player.getGroups().get(i);
        }
        return ret;
    }

    public synchronized Group getNextGroup(Group group) {
        List<Group> laddergroups = this.getLadderGroups(group.getLadder());
        for (int i = 0; i < laddergroups.size(); ++i) {
            if (laddergroups.get(i).getRank() != group.getRank()) continue;
            if (i + 1 < laddergroups.size()) {
                return laddergroups.get(i + 1);
            }
            return null;
        }
        throw new IllegalArgumentException("group ladder does not exist (anymore)");
    }

    public synchronized Group getPreviousGroup(Group group) {
        List<Group> laddergroups = this.getLadderGroups(group.getLadder());
        for (int i = 0; i < laddergroups.size(); ++i) {
            if (laddergroups.get(i).getRank() != group.getRank()) continue;
            if (i > 0) {
                return laddergroups.get(i - 1);
            }
            return null;
        }
        throw new IllegalArgumentException("group ladder does not exist (anymore)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Group> getLadderGroups(String ladder) {
        ArrayList<Group> ret = new ArrayList<Group>();
        this.grouplock.readLock().lock();
        try {
            for (Group g : this.groups) {
                if (!g.getLadder().equalsIgnoreCase(ladder)) continue;
                ret.add(g);
            }
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        Collections.sort(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> getLadders() {
        ArrayList<String> ret = new ArrayList<String>();
        this.grouplock.readLock().lock();
        try {
            for (Group g : this.groups) {
                if (Statics.listContains(ret, g.getLadder())) continue;
                ret.add(g.getLadder());
            }
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Group> getDefaultGroups() {
        ArrayList<Group> ret = new ArrayList<Group>();
        this.grouplock.readLock().lock();
        try {
            for (Group g : this.groups) {
                if (!g.isDefault()) continue;
                ret.add(g);
            }
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Group getGroup(String groupname) {
        if (groupname == null) {
            return null;
        }
        this.grouplock.readLock().lock();
        try {
            for (Group g : this.groups) {
                if (!g.getName().equalsIgnoreCase(groupname)) continue;
                Group group = g;
                return group;
            }
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        return null;
    }

    public synchronized User getUser(String usernameoruuid) {
        return this.getUser(usernameoruuid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized User getUser(String usernameoruuid, boolean loadfromdb) {
        if (usernameoruuid == null) {
            return null;
        }
        UUID uuid = Statics.parseUUID(usernameoruuid);
        if (this.config.isUseUUIDs() && uuid != null) {
            return this.getUser(uuid);
        }
        this.userlock.readLock().lock();
        try {
            for (User u : this.users) {
                if (!u.getName().equalsIgnoreCase(usernameoruuid)) continue;
                User user = u;
                return user;
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
        if (loadfromdb) {
            User u = null;
            if (this.config.isUseUUIDs()) {
                if (uuid == null) {
                    uuid = this.UUIDPlayerDB.getUUID(usernameoruuid);
                }
                if (uuid != null) {
                    u = this.backEnd.loadUser(uuid);
                }
            } else {
                u = this.backEnd.loadUser(usernameoruuid);
            }
            if (u != null) {
                this.addUserToCache(u);
                return u;
            }
        }
        return null;
    }

    public synchronized User getUser(UUID uuid) {
        return this.getUser(uuid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized User getUser(UUID uuid, boolean loadfromdb) {
        User u;
        if (uuid == null) {
            return null;
        }
        this.userlock.readLock().lock();
        try {
            for (User u2 : this.users) {
                if (!u2.getUUID().equals(uuid)) continue;
                User user = u2;
                return user;
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
        if (loadfromdb && (u = this.backEnd.loadUser(uuid)) != null) {
            this.addUserToCache(u);
            return u;
        }
        return null;
    }

    public User createTempUser(String playername, UUID uuid) {
        List<Group> groups = this.getDefaultGroups();
        User u = new User(playername, uuid, groups, new ArrayList<String>(), new HashMap<String, Server>(), null, null, null);
        this.addUserToCache(u);
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getGroups() {
        List<Group> l;
        this.grouplock.readLock().lock();
        try {
            l = Collections.unmodifiableList(this.groups);
        }
        finally {
            this.grouplock.readLock().unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers() {
        List<User> l;
        this.userlock.readLock().lock();
        try {
            l = Collections.unmodifiableList(this.users);
        }
        finally {
            this.userlock.readLock().unlock();
        }
        return l;
    }

    public List<String> getRegisteredUsers() {
        return this.backEnd.getRegisteredUsers();
    }

    public List<String> getGroupUsers(Group group) {
        return this.backEnd.getGroupUsers(group);
    }

    public synchronized void deleteUser(User user) {
        this.removeUserFromCache(user);
        this.backEnd.deleteUser(user);
        BungeePerms.getInstance().getNetworkNotifier().deleteUser(user, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
    }

    public synchronized void deleteGroup(Group group) {
        this.removeGroupFromCache(group);
        this.backEnd.deleteGroup(group);
        this.validateUsersGroups();
        BungeePerms.getInstance().getNetworkNotifier().deleteGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public synchronized void addUser(User user) {
        this.addUserToCache(user);
        this.backEnd.saveUser(user, true);
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addGroup(Group group) {
        this.grouplock.writeLock().lock();
        try {
            this.groups.add(group);
            Collections.sort(this.groups);
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
        this.backEnd.saveGroup(group, true);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void format() {
        this.backEnd.format(this.backEnd.loadGroups(), this.backEnd.loadUsers(), this.permsversion);
        this.backEnd.load();
        BungeePerms.getInstance().getNetworkNotifier().reloadAll(null);
    }

    public int cleanup() {
        int res = this.backEnd.cleanup(this.backEnd.loadGroups(), this.backEnd.loadUsers(), this.permsversion);
        this.backEnd.load();
        BungeePerms.getInstance().getNetworkNotifier().reloadAll(null);
        return res;
    }

    public void addUserGroup(User user, Group group) {
        user.getGroups().add(group);
        Collections.sort(user.getGroups());
        this.backEnd.saveUserGroups(user);
        user.recalcPerms();
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void removeUserGroup(User user, Group group) {
        user.getGroups().remove(group);
        Collections.sort(user.getGroups());
        this.backEnd.saveUserGroups(user);
        user.recalcPerms();
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void addUserPerm(User user, String perm) {
        user.getExtraPerms().add(Statics.toLower(perm));
        this.backEnd.saveUserPerms(user);
        user.recalcPerms();
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void removeUserPerm(User user, String perm) {
        user.getExtraPerms().remove(Statics.toLower(perm));
        this.backEnd.saveUserPerms(user);
        user.recalcPerms();
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void addUserPerServerPerm(User user, String server, String perm) {
        Server srv = user.getServer(server);
        srv.getPerms().add(Statics.toLower(perm));
        this.backEnd.saveUserPerServerPerms(user, Statics.toLower(server));
        user.recalcPerms(Statics.toLower(server));
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void removeUserPerServerPerm(User user, String server, String perm) {
        Server srv = user.getServer(server);
        srv.getPerms().remove(Statics.toLower(perm));
        this.backEnd.saveUserPerServerPerms(user, Statics.toLower(server));
        user.recalcPerms(server);
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void addUserPerServerWorldPerm(User user, String server, String world, String perm) {
        Server srv = user.getServer(server);
        World w = srv.getWorld(world);
        w.getPerms().add(Statics.toLower(perm));
        this.backEnd.saveUserPerServerWorldPerms(user, Statics.toLower(server), Statics.toLower(world));
        user.recalcPerms(server, world);
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void removeUserPerServerWorldPerm(User user, String server, String world, String perm) {
        Server srv = user.getServer(server);
        World w = srv.getWorld(world);
        w.getPerms().remove(Statics.toLower(perm));
        this.backEnd.saveUserPerServerWorldPerms(user, Statics.toLower(server), Statics.toLower(world));
        user.recalcPerms(server, world);
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
    }

    public void setUserDisplay(User user, String display, String server, String world) {
        if (server == null) {
            user.setDisplay(display);
        } else if (world == null) {
            user.getServer(server).setDisplay(display);
        } else {
            user.getServer(server).getWorld(world).setDisplay(display);
        }
        this.backEnd.saveUserDisplay(user, Statics.toLower(server), Statics.toLower(world));
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
    }

    public void setUserPrefix(User user, String prefix, String server, String world) {
        if (server == null) {
            user.setPrefix(prefix);
        } else if (world == null) {
            user.getServer(server).setPrefix(prefix);
        } else {
            user.getServer(server).getWorld(world).setPrefix(prefix);
        }
        this.backEnd.saveUserPrefix(user, Statics.toLower(server), Statics.toLower(world));
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
    }

    public void setUserSuffix(User user, String suffix, String server, String world) {
        if (server == null) {
            user.setSuffix(suffix);
        } else if (world == null) {
            user.getServer(server).setSuffix(suffix);
        } else {
            user.getServer(server).getWorld(world).setSuffix(suffix);
        }
        this.backEnd.saveUserSuffix(user, Statics.toLower(server), Statics.toLower(world));
        BungeePerms.getInstance().getNetworkNotifier().reloadUser(user, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(user);
    }

    public void addGroupPerm(Group group, String perm) {
        group.getPerms().add(Statics.toLower(perm));
        this.backEnd.saveGroupPerms(group);
        for (Group g : this.groups) {
            g.recalcPerms();
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void removeGroupPerm(Group group, String perm) {
        group.getPerms().remove(Statics.toLower(perm));
        this.backEnd.saveGroupPerms(group);
        for (Group g : this.groups) {
            g.recalcPerms();
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void addGroupPerServerPerm(Group group, String server, String perm) {
        Server srv = group.getServer(server);
        srv.getPerms().add(Statics.toLower(perm));
        this.backEnd.saveGroupPerServerPerms(group, Statics.toLower(server));
        for (Group g : this.groups) {
            g.recalcPerms(server);
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void removeGroupPerServerPerm(Group group, String server, String perm) {
        Server srv = group.getServer(server);
        srv.getPerms().remove(Statics.toLower(perm));
        this.backEnd.saveGroupPerServerPerms(group, Statics.toLower(server));
        for (Group g : this.groups) {
            g.recalcPerms(server);
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void addGroupPerServerWorldPerm(Group group, String server, String world, String perm) {
        Server srv = group.getServer(server);
        World w = srv.getWorld(world);
        w.getPerms().add(Statics.toLower(perm));
        this.backEnd.saveGroupPerServerWorldPerms(group, Statics.toLower(server), Statics.toLower(world));
        for (Group g : this.groups) {
            g.recalcPerms(server, world);
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void removeGroupPerServerWorldPerm(Group group, String server, String world, String perm) {
        Server srv = group.getServer(server);
        World w = srv.getWorld(world);
        w.getPerms().remove(Statics.toLower(perm));
        this.backEnd.saveGroupPerServerWorldPerms(group, Statics.toLower(server), Statics.toLower(world));
        for (Group g : this.groups) {
            g.recalcPerms(server, world);
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void addGroupInheritance(Group group, Group toadd) {
        group.getInheritances().add(toadd.getName());
        Collections.sort(group.getInheritances());
        this.backEnd.saveGroupInheritances(group);
        for (Group g : this.groups) {
            g.recalcPerms();
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void removeGroupInheritance(Group group, Group toremove) {
        group.getInheritances().remove(toremove.getName());
        Collections.sort(group.getInheritances());
        this.backEnd.saveGroupInheritances(group);
        for (Group g : this.groups) {
            g.recalcPerms();
        }
        for (User u : this.users) {
            u.recalcPerms();
        }
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
    }

    public void ladderGroup(Group group, String ladder) {
        group.setLadder(ladder);
        this.backEnd.saveGroupLadder(group);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void rankGroup(Group group, int rank) {
        group.setRank(rank);
        Collections.sort(this.groups);
        this.backEnd.saveGroupRank(group);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void weightGroup(Group group, int weight) {
        group.setWeight(weight);
        Collections.sort(this.groups);
        this.backEnd.saveGroupWeight(group);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void setGroupDefault(Group group, boolean isdefault) {
        group.setIsdefault(isdefault);
        this.backEnd.saveGroupDefault(group);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void setGroupDisplay(Group group, String display, String server, String world) {
        if (server == null) {
            group.setDisplay(display);
        } else if (world == null) {
            group.getServer(server).setDisplay(display);
        } else {
            group.getServer(server).getWorld(world).setDisplay(display);
        }
        this.backEnd.saveGroupDisplay(group, server, world);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void setGroupPrefix(Group group, String prefix, String server, String world) {
        if (server == null) {
            group.setPrefix(prefix);
        } else if (world == null) {
            group.getServer(server).setPrefix(prefix);
        } else {
            group.getServer(server).getWorld(world).setPrefix(prefix);
        }
        this.backEnd.saveGroupPrefix(group, server, world);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public void setGroupSuffix(Group group, String suffix, String server, String world) {
        if (server == null) {
            group.setSuffix(suffix);
        } else if (world == null) {
            group.getServer(server).setSuffix(suffix);
        } else {
            group.getServer(server).getWorld(world).setSuffix(suffix);
        }
        this.backEnd.saveGroupSuffix(group, server, world);
        BungeePerms.getInstance().getNetworkNotifier().reloadGroup(group, null);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(group);
    }

    public synchronized void migrateBackEnd(BackEndType bet) {
        Migrator migrator = null;
        switch (bet) {
            case MySQL2: {
                migrator = new Migrate2MySQL2(this.config, this.debug);
                break;
            }
            case MySQL: {
                migrator = new Migrate2MySQL(this.config, this.debug);
                break;
            }
            case YAML: {
                migrator = new Migrate2YAML(this.config);
                break;
            }
            default: {
                throw new UnsupportedOperationException("bet = " + bet.name());
            }
        }
        migrator.migrate(this.backEnd.loadGroups(), this.backEnd.loadUsers(), this.permsversion);
        this.backEnd.load();
    }

    public void migrateUseUUID(Map<String, UUID> uuids) {
        List<Group> groups = this.backEnd.loadGroups();
        List<User> users = this.backEnd.loadUsers();
        int version = this.backEnd.loadVersion();
        BungeePerms.getInstance().getConfig().setUseUUIDs(true);
        this.backEnd.clearDatabase();
        for (Group g : groups) {
            this.backEnd.saveGroup(g, false);
        }
        for (User u : users) {
            UUID uuid = uuids.get(u.getName());
            if (uuid == null) continue;
            u.setUUID(uuid);
            this.backEnd.saveUser(u, false);
        }
        this.backEnd.saveVersion(version, true);
    }

    public void migrateUsePlayerNames(Map<UUID, String> playernames) {
        List<Group> groups = this.backEnd.loadGroups();
        List<User> users = this.backEnd.loadUsers();
        int version = this.backEnd.loadVersion();
        BungeePerms.getInstance().getConfig().setUseUUIDs(false);
        this.backEnd.clearDatabase();
        for (Group g : groups) {
            this.backEnd.saveGroup(g, false);
        }
        for (User u : users) {
            String playername = playernames.get(u.getUUID());
            if (playername == null) continue;
            u.setName(playername);
            this.backEnd.saveUser(u, false);
        }
        this.backEnd.saveVersion(version, true);
    }

    public void migrateUUIDPlayerDB(UUIDPlayerDBType type) {
        Map<UUID, String> map = this.UUIDPlayerDB.getAll();
        switch (type) {
            case None: {
                this.UUIDPlayerDB = new NoneUUIDPlayerDB();
                break;
            }
            case YAML: {
                this.UUIDPlayerDB = new YAMLUUIDPlayerDB();
                break;
            }
            case MySQL: {
                this.UUIDPlayerDB = new MySQLUUIDPlayerDB();
                break;
            }
            default: {
                throw new UnsupportedOperationException("type = " + (Object)((Object)type));
            }
        }
        BungeePerms.getInstance().getConfig().setUUIDPlayerDB(this.UUIDPlayerDB.getType());
        this.UUIDPlayerDB.clear();
        for (Map.Entry<UUID, String> e : map.entrySet()) {
            this.UUIDPlayerDB.update(e.getKey(), e.getValue());
        }
    }

    public void reloadUser(String user) {
        User u = this.getUser(user);
        if (u == null) {
            this.debug.log("User " + user + " not found!!!");
            return;
        }
        this.backEnd.reloadUser(u);
        u.recalcPerms();
    }

    public void reloadUser(UUID uuid) {
        User u = this.getUser(uuid);
        if (u == null) {
            this.debug.log("User " + uuid + " not found!!!");
            return;
        }
        this.backEnd.reloadUser(u);
        u.recalcPerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadGroup(String group) {
        Group g = this.getGroup(group);
        if (g == null) {
            this.debug.log("Group " + group + " not found!!!");
            return;
        }
        boolean holdread = false;
        this.grouplock.writeLock().lock();
        try {
            this.backEnd.reloadGroup(g);
            Collections.sort(this.groups);
            this.grouplock.readLock().lock();
            holdread = true;
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
        try {
            for (Group gr : this.groups) {
                gr.recalcPerms();
            }
        }
        finally {
            if (holdread) {
                this.grouplock.readLock().unlock();
            }
        }
        this.userlock.readLock().lock();
        try {
            for (User u : this.users) {
                u.recalcPerms();
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadUsers() {
        this.userlock.readLock().lock();
        try {
            for (User u : this.users) {
                this.backEnd.reloadUser(u);
                u.recalcPerms();
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadGroups() {
        boolean holdread = false;
        this.grouplock.writeLock().lock();
        try {
            for (Group g : this.groups) {
                this.backEnd.reloadGroup(g);
            }
            Collections.sort(this.groups);
            this.grouplock.readLock().lock();
            holdread = true;
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
        try {
            for (Group g : this.groups) {
                g.recalcPerms();
            }
        }
        finally {
            if (holdread) {
                this.grouplock.readLock().unlock();
            }
        }
        this.userlock.readLock().lock();
        try {
            for (User u : this.users) {
                u.recalcPerms();
            }
        }
        finally {
            this.userlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToCache(User u) {
        this.userlock.writeLock().lock();
        try {
            this.users.add(u);
        }
        finally {
            this.userlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromCache(User u) {
        this.userlock.writeLock().lock();
        try {
            this.users.remove(u);
        }
        finally {
            this.userlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupToCache(Group g) {
        this.grouplock.writeLock().lock();
        try {
            this.groups.add(g);
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupFromCache(Group g) {
        this.grouplock.writeLock().lock();
        try {
            this.groups.remove(g);
        }
        finally {
            this.grouplock.writeLock().unlock();
        }
    }

    public BackEnd getBackEnd() {
        return this.backEnd;
    }

    public void setBackEnd(BackEnd backEnd) {
        this.backEnd = backEnd;
    }

    public UUIDPlayerDB getUUIDPlayerDB() {
        return this.UUIDPlayerDB;
    }

    ReadWriteLock getUserlock() {
        return this.userlock;
    }
}

