/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.alpenblock.bungeeperms.BPPermission;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsPostProcessor;
import net.alpenblock.bungeeperms.PermissionsPreProcessor;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.platform.Sender;

public class PermissionsResolver {
    public final List<PermissionsPreProcessor> preprocessors = new ArrayList<PermissionsPreProcessor>();
    public final List<PermissionsPostProcessor> postprocessors = new ArrayList<PermissionsPostProcessor>();
    private boolean useRegex = false;

    public void registerProcessor(PermissionsPreProcessor processor) {
        this.preprocessors.add(processor);
    }

    public void unregisterProcessor(PermissionsPreProcessor processor) {
        this.preprocessors.remove(processor);
    }

    public void registerProcessor(PermissionsPostProcessor processor) {
        this.postprocessors.add(processor);
    }

    public void unregisterProcessor(PermissionsPostProcessor processor) {
        this.postprocessors.remove(processor);
    }

    public List<String> preprocess(List<String> perms, Sender s) {
        for (PermissionsPreProcessor p : this.preprocessors) {
            perms = p.process(perms, s);
        }
        return perms;
    }

    public List<BPPermission> preprocessWithOrigin(List<BPPermission> perms, Sender s) {
        for (PermissionsPreProcessor p : this.preprocessors) {
            perms = p.processWithOrigin(perms, s);
        }
        return perms;
    }

    public Boolean postprocess(String perm, Boolean result, Sender s) {
        for (PermissionsPostProcessor p : this.postprocessors) {
            result = p.process(perm, result, s);
        }
        return result;
    }

    public Boolean has(List<String> perms, String perm) {
        if (this.useRegex) {
            return PermissionsResolver.hasRegex(perms, perm);
        }
        return PermissionsResolver.hasNormal(perms, perm);
    }

    public static Boolean hasNormal(List<String> perms, String perm) {
        Boolean has = null;
        List<String> lperm = Statics.toList(perm, ".");
        for (String p : perms) {
            if (p.equalsIgnoreCase(perm)) {
                has = true;
                continue;
            }
            if (p.equalsIgnoreCase("-" + perm)) {
                has = false;
                continue;
            }
            if (!p.endsWith("*")) continue;
            List<String> lp = Statics.toList(p, ".");
            try {
                int index;
                for (index = 0; index < lp.size() && index < lperm.size() && (lp.get(index).equalsIgnoreCase(lperm.get(index)) || index == 0 && lp.get(index).equalsIgnoreCase("-" + lperm.get(index))); ++index) {
                }
                if (!lp.get(index).equalsIgnoreCase("*") && (index != 0 || !lp.get(0).equalsIgnoreCase("-*"))) continue;
                has = !lp.get(0).startsWith("-");
            }
            catch (Exception e) {
                BungeePerms.getInstance().getDebug().log(e);
            }
        }
        return has;
    }

    public static Boolean hasRegex(List<String> perms, String perm) {
        Boolean has = null;
        Iterator<String> i$ = perms.iterator();
        while (i$.hasNext()) {
            boolean matches;
            String p;
            String tocheck = p = i$.next();
            boolean negate = false;
            if (p.startsWith("-")) {
                negate = true;
                tocheck = p.substring(1);
            }
            if (!(matches = perm.matches(tocheck = tocheck.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("#", "\\.")))) continue;
            has = !negate;
        }
        return has;
    }

    public List<String> simplify(List<String> perms) {
        if (this.useRegex) {
            return PermissionsResolver.simplifyRegex(perms);
        }
        return PermissionsResolver.simplifyNormal(perms);
    }

    public static List<String> simplifyNormal(List<String> perms) {
        return perms;
    }

    public static List<String> simplifyRegex(List<String> perms) {
        return perms;
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }
}

