/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BPPermission;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.ChatColor;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.PermEntity;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.World;
import net.alpenblock.bungeeperms.platform.Sender;

public class User
implements PermEntity {
    private Map<String, List<String>> cachedPerms = new HashMap<String, List<String>>();
    private Map<String, Map<String, Map<String, Boolean>>> permCheckResults = new HashMap<String, Map<String, Map<String, Boolean>>>();
    private String name;
    private UUID UUID;
    private List<Group> groups;
    private List<String> perms;
    private Map<String, Server> servers;
    private String display;
    private String prefix;
    private String suffix;
    private long lastAccess;

    public User(String name, UUID UUID2, List<Group> groups, List<String> extraPerms, Map<String, Server> servers, String display, String prefix, String suffix) {
        this.name = name;
        this.UUID = UUID2;
        this.groups = groups;
        this.perms = extraPerms;
        this.servers = servers;
        this.display = display;
        this.prefix = prefix;
        this.suffix = suffix;
        this.access();
    }

    @Override
    public Server getServer(String name) {
        this.access();
        name = Statics.toLower(name);
        if (name == null) {
            return null;
        }
        Server s = this.servers.get(name);
        if (s == null) {
            s = new Server(name, new ArrayList<String>(), new HashMap<String, World>(), null, null, null);
            this.servers.put(name, s);
        }
        return s;
    }

    public boolean hasPerm(String perm) {
        this.access();
        Sender s = this.getSender();
        return this.hasPerm(s, perm);
    }

    public boolean hasPermOnServer(String perm, String server) {
        this.access();
        Sender s = this.getSender();
        return this.hasPermOnServer(s, perm, server);
    }

    public boolean hasPermOnServerInWorld(String perm, String server, String world) {
        this.access();
        Sender s = this.getSender();
        return this.hasPermOnServerInWorld(s, perm, server, world);
    }

    public boolean hasPerm(Sender s, String perm) {
        this.access();
        perm = Statics.toLower(perm);
        Boolean cached = this.getCachedResult(perm, null, null);
        if (cached != null) {
            this.debug(perm, cached);
            return cached;
        }
        List<String> perms = this.getEffectivePerms();
        perms = BungeePerms.getInstance().getPermissionsResolver().preprocess(perms, s);
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, perm);
        has = BungeePerms.getInstance().getPermissionsResolver().postprocess(perm, has, s);
        has = has != null && has != false;
        this.setCachedResult(perm, has, null, null);
        this.debug(perm, has);
        return has;
    }

    public boolean hasPermOnServer(Sender s, String perm, String server) {
        this.access();
        perm = Statics.toLower(perm);
        server = Statics.toLower(server);
        Boolean cached = this.getCachedResult(perm, server, null);
        if (cached != null) {
            this.debug(perm, cached);
            return cached;
        }
        List<String> perms = this.getEffectivePerms(server);
        perms = BungeePerms.getInstance().getPermissionsResolver().preprocess(perms, s);
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, perm);
        has = BungeePerms.getInstance().getPermissionsResolver().postprocess(perm, has, s);
        has = has != null && has != false;
        this.setCachedResult(perm, has, server, null);
        this.debug(perm, has);
        return has;
    }

    public boolean hasPermOnServerInWorld(Sender s, String perm, String server, String world) {
        this.access();
        perm = Statics.toLower(perm);
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        Boolean cached = this.getCachedResult(perm, server, world);
        if (cached != null) {
            this.debug(perm, cached);
            return cached;
        }
        List<String> perms = this.getEffectivePerms(server, world);
        perms = BungeePerms.getInstance().getPermissionsResolver().preprocess(perms, s);
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, perm);
        has = BungeePerms.getInstance().getPermissionsResolver().postprocess(perm, has, s);
        has = has != null && has != false;
        this.setCachedResult(perm, has, server, world);
        this.debug(perm, has);
        return has;
    }

    public List<String> getEffectivePerms() {
        this.access();
        List<String> effperms = this.cachedPerms.get("global");
        if (effperms == null) {
            effperms = this.calcEffectivePerms();
            this.cachedPerms.put("global", effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> getEffectivePerms(String server) {
        this.access();
        if (server == null) {
            return this.getEffectivePerms();
        }
        List<String> effperms = this.cachedPerms.get(Statics.toLower(server = Statics.toLower(server)));
        if (effperms == null) {
            effperms = this.calcEffectivePerms(server);
            this.cachedPerms.put(server, effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> getEffectivePerms(String server, String world) {
        this.access();
        if (world == null) {
            return this.getEffectivePerms(server);
        }
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> effperms = this.cachedPerms.get(server + ";" + world);
        if (effperms == null) {
            effperms = this.calcEffectivePerms(server, world);
            this.cachedPerms.put(server + ";" + world, effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> calcEffectivePerms() {
        this.access();
        List<String> ret = new ArrayList<String>();
        for (Group g : this.groups) {
            List<String> gperms = g.getEffectivePerms();
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public List<String> calcEffectivePerms(String server) {
        this.access();
        List<String> ret = new ArrayList<String>();
        for (Group g : this.groups) {
            List<String> gperms = g.getEffectivePerms(server);
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        Server srv = this.getServer(server);
        if (srv != null) {
            List<String> perserverperms = srv.getPerms();
            ret.addAll(perserverperms);
        }
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public List<String> calcEffectivePerms(String server, String world) {
        this.access();
        List<String> ret = new ArrayList<String>();
        for (Group g : this.groups) {
            List<String> gperms = g.getEffectivePerms(server, world);
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        Server srv = this.getServer(server);
        if (srv != null) {
            List<String> perserverperms = srv.getPerms();
            ret.addAll(perserverperms);
            World w = srv.getWorld(world);
            if (w != null) {
                List<String> serverworldperms = w.getPerms();
                ret.addAll(serverworldperms);
            }
        }
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public void recalcPerms() {
        this.recalcPerms0();
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(this);
    }

    public void recalcPerms(String server) {
        this.recalcPerms0(server);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(this);
    }

    public void recalcPerms(String server, String world) {
        this.recalcPerms0(server, world);
        BungeePerms.getInstance().getEventDispatcher().dispatchUserChangeEvent(this);
    }

    private void recalcPerms0() {
        this.access();
        for (Map.Entry<String, List<String>> e : this.cachedPerms.entrySet()) {
            String where = e.getKey();
            List<String> l = Statics.toList(where, ";");
            String server = l.get(0);
            if (l.size() == 1) {
                if (server.equalsIgnoreCase("global")) {
                    this.cachedPerms.put("global", this.calcEffectivePerms());
                    continue;
                }
                List<String> effperms = this.calcEffectivePerms(server);
                this.cachedPerms.put(Statics.toLower(server), effperms);
                continue;
            }
            if (l.size() != 2) continue;
            String world = l.get(1);
            this.recalcPerms0(server, world);
        }
        this.permCheckResults.clear();
    }

    private void recalcPerms0(String server) {
        this.access();
        server = Statics.toLower(server);
        for (Map.Entry<String, List<String>> e : this.cachedPerms.entrySet()) {
            String where = e.getKey();
            List<String> l = Statics.toList(where, ";");
            String lserver = Statics.toLower(l.get(0));
            if (!lserver.equalsIgnoreCase(server)) continue;
            if (l.size() == 1) {
                List<String> effperms = this.calcEffectivePerms(lserver);
                this.cachedPerms.put(lserver, effperms);
                continue;
            }
            if (l.size() != 2) continue;
            String world = Statics.toLower(l.get(1));
            this.recalcPerms0(lserver, world);
        }
        this.permCheckResults.clear();
    }

    private void recalcPerms0(String server, String world) {
        this.access();
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> effperms = this.calcEffectivePerms(server, world);
        this.cachedPerms.put(server + ";" + world, effperms);
        this.permCheckResults.clear();
    }

    public boolean isNothingSpecial() {
        this.access();
        for (Group g : this.groups) {
            if (g.isDefault()) continue;
            return false;
        }
        for (Server s : this.servers.values()) {
            if (!(s.getPerms().isEmpty() && Statics.isEmpty(s.getDisplay()) && Statics.isEmpty(s.getPrefix()) && Statics.isEmpty(s.getSuffix()))) {
                return false;
            }
            for (World w : s.getWorlds().values()) {
                if (s.getPerms().isEmpty() && Statics.isEmpty(w.getDisplay()) && Statics.isEmpty(w.getPrefix()) && Statics.isEmpty(w.getSuffix())) continue;
                return false;
            }
        }
        return this.perms.isEmpty() && Statics.isEmpty(this.display) && Statics.isEmpty(this.prefix) && Statics.isEmpty(this.suffix);
    }

    public Group getGroupByLadder(String ladder) {
        this.access();
        for (Group g : this.groups) {
            if (!g.getLadder().equalsIgnoreCase(ladder)) continue;
            return g;
        }
        return null;
    }

    public List<BPPermission> getPermsWithOrigin(String server, String world) {
        this.access();
        List<BPPermission> ret = new ArrayList<BPPermission>();
        for (Group group : this.groups) {
            ret.addAll(group.getPermsWithOrigin(server, world));
        }
        for (String string : this.perms) {
            BPPermission perm = new BPPermission(string, this.name, false, null, null);
            ret.add(perm);
        }
        for (Map.Entry entry : this.servers.entrySet()) {
            if (server == null || !((String)entry.getKey()).equalsIgnoreCase(server)) continue;
            List<String> perserverPerms = ((Server)entry.getValue()).getPerms();
            for (String string : perserverPerms) {
                BPPermission perm = new BPPermission(string, this.name, false, (String)entry.getKey(), null);
                ret.add(perm);
            }
            for (Map.Entry entry2 : ((Server)entry.getValue()).getWorlds().entrySet()) {
                if (world == null || !((String)entry2.getKey()).equalsIgnoreCase(world)) continue;
                List<String> perserverWorldPerms = ((World)entry2.getValue()).getPerms();
                for (String s2 : perserverWorldPerms) {
                    BPPermission perm2 = new BPPermission(s2, this.name, false, (String)entry.getKey(), (String)entry2.getKey());
                    ret.add(perm2);
                }
            }
        }
        ret = BungeePerms.getInstance().getPermissionsResolver().preprocessWithOrigin(ret, this.getSender());
        return ret;
    }

    public List<String> getGroupsString() {
        this.access();
        ArrayList<String> ret = new ArrayList<String>();
        for (Group g : this.groups) {
            ret.add(g.getName());
        }
        return ret;
    }

    public int getOwnPermissionsCount(String server, String world) {
        this.access();
        int count = this.perms.size();
        Server s = this.getServer(server);
        if (s == null) {
            return count;
        }
        count += s.getPerms().size();
        World w = s.getWorld(world);
        if (world == null) {
            return count;
        }
        return count += w.getPerms().size();
    }

    public int getPermissionsCount(String server, String world) {
        this.access();
        int count = this.getOwnPermissionsCount(server, world);
        for (Group g : this.groups) {
            count += g.getPermissionsCount(server, world);
        }
        return count;
    }

    public String buildPrefix() {
        this.access();
        Sender sender = this.getSender();
        return this.buildPrefix(sender);
    }

    public String buildPrefix(Sender sender) {
        return this.buildPrefix(sender != null ? sender.getServer() : null, sender != null ? sender.getWorld() : null);
    }

    public String buildPrefix(String server, String world) {
        Server s;
        this.access();
        String prefix = "";
        ArrayList<String> prefixes = new ArrayList<String>();
        for (Group g : this.groups) {
            World w;
            Server s2;
            if (!Statics.isEmpty(g.getPrefix())) {
                prefixes.add(g.getPrefix());
            }
            if ((s2 = g.getServer(server)) == null) continue;
            if (!Statics.isEmpty(s2.getPrefix())) {
                prefixes.add(s2.getPrefix());
            }
            if ((w = s2.getWorld(world)) == null || Statics.isEmpty(w.getPrefix())) continue;
            prefixes.add(w.getPrefix());
        }
        if (!Statics.isEmpty(this.prefix)) {
            prefixes.add(this.prefix);
        }
        if ((s = this.getServer(server)) != null) {
            World w;
            if (!Statics.isEmpty(s.getPrefix())) {
                prefixes.add(s.getPrefix());
            }
            if ((w = s.getWorld(world)) != null && !Statics.isEmpty(w.getPrefix())) {
                prefixes.add(w.getPrefix());
            }
        }
        for (String p : prefixes) {
            if (!(ChatColor.strip(p.replaceAll("&", "\u00a7")).isEmpty() || prefix.isEmpty() || ChatColor.strip(prefix.replaceAll("&", "\u00a7")).endsWith(" "))) {
                prefix = prefix + " ";
            }
            prefix = prefix + p;
        }
        return prefix + (BungeePerms.getInstance().getConfig().isTerminatePrefixSpace() ? " " : "") + (BungeePerms.getInstance().getConfig().isTerminatePrefixReset() ? ChatColor.RESET : "");
    }

    public String buildSuffix() {
        this.access();
        Sender sender = this.getSender();
        return this.buildSuffix(sender);
    }

    public String buildSuffix(Sender sender) {
        return this.buildSuffix(sender != null ? sender.getServer() : null, sender != null ? sender.getWorld() : null);
    }

    public String buildSuffix(String server, String world) {
        Server s;
        this.access();
        String suffix = "";
        ArrayList<String> suffixes = new ArrayList<String>();
        for (Group g : this.groups) {
            World w;
            Server s2;
            if (!Statics.isEmpty(g.getSuffix())) {
                suffixes.add(g.getSuffix());
            }
            if ((s2 = g.getServer(server)) == null) continue;
            if (!Statics.isEmpty(s2.getSuffix())) {
                suffixes.add(s2.getSuffix());
            }
            if ((w = s2.getWorld(world)) == null || Statics.isEmpty(w.getSuffix())) continue;
            suffixes.add(w.getSuffix());
        }
        if (!Statics.isEmpty(this.suffix)) {
            suffixes.add(this.suffix);
        }
        if ((s = this.getServer(server)) != null) {
            World w;
            if (!Statics.isEmpty(s.getSuffix())) {
                suffixes.add(s.getSuffix());
            }
            if ((w = s.getWorld(world)) != null && !Statics.isEmpty(w.getSuffix())) {
                suffixes.add(w.getSuffix());
            }
        }
        for (String suf : suffixes) {
            if (!(ChatColor.strip(suf.replaceAll("&", "\u00a7")).isEmpty() || suffix.isEmpty() || ChatColor.strip(suffix.replaceAll("&", "\u00a7")).endsWith(" "))) {
                suffix = suffix + " ";
            }
            suffix = suffix + suf;
        }
        return suffix + (BungeePerms.getInstance().getConfig().isTerminateSuffixSpace() ? " " : "") + (BungeePerms.getInstance().getConfig().isTerminateSuffixReset() ? ChatColor.RESET : "");
    }

    public void flushCache() {
        this.permCheckResults.clear();
    }

    private Sender getSender() {
        return BungeePerms.getInstance().getConfig().isUseUUIDs() ? BungeePerms.getInstance().getPlugin().getPlayer(this.UUID) : BungeePerms.getInstance().getPlugin().getPlayer(this.name);
    }

    private void debug(String perm, boolean result) {
        if (BungeePerms.getInstance().getConfig().isDebug()) {
            BungeePerms.getLogger().info("perm check: " + this.name + " has " + perm + ": " + result);
        }
    }

    private void access() {
        this.lastAccess = System.currentTimeMillis();
    }

    private Boolean getCachedResult(String permission, String server, String world) {
        return this.getPermMap(server, world).get(permission);
    }

    private void setCachedResult(String permission, boolean value, String server, String world) {
        this.getPermMap(server, world).put(permission, value);
    }

    private Map<String, Boolean> getPermMap(String server, String world) {
        Map<String, Boolean> permmap;
        Map<String, Map<String, Boolean>> worldmap = this.permCheckResults.get(server);
        if (worldmap == null) {
            worldmap = new HashMap<String, Map<String, Boolean>>();
            this.permCheckResults.put(server, worldmap);
        }
        if ((permmap = worldmap.get(world)) == null) {
            permmap = new HashMap<String, Boolean>();
            worldmap.put(world, permmap);
        }
        return permmap;
    }

    @Deprecated
    public List<String> getExtraPerms() {
        return this.perms;
    }

    @Deprecated
    public void setExtraPerms(List<String> perms) {
        this.perms = perms;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.UUID;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getPerms() {
        return this.perms;
    }

    @Override
    public Map<String, Server> getServers() {
        return this.servers;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setUUID(UUID UUID2) {
        this.UUID = UUID2;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public void setPerms(List<String> perms) {
        this.perms = perms;
    }

    public void setServers(Map<String, Server> servers) {
        this.servers = servers;
    }

    @Override
    public void setDisplay(String display) {
        this.display = display;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public String toString() {
        return "User(cachedPerms=" + this.getCachedPerms() + ", permCheckResults=" + this.getPermCheckResults() + ", name=" + this.getName() + ", UUID=" + this.getUUID() + ", groups=" + this.getGroups() + ", perms=" + this.getPerms() + ", servers=" + this.getServers() + ", display=" + this.getDisplay() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", lastAccess=" + this.getLastAccess() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$cachedPerms = this.getCachedPerms();
        Map<String, List<String>> other$cachedPerms = other.getCachedPerms();
        if (this$cachedPerms == null ? other$cachedPerms != null : !((Object)this$cachedPerms).equals(other$cachedPerms)) {
            return false;
        }
        Map<String, Map<String, Map<String, Boolean>>> this$permCheckResults = this.getPermCheckResults();
        Map<String, Map<String, Map<String, Boolean>>> other$permCheckResults = other.getPermCheckResults();
        if (this$permCheckResults == null ? other$permCheckResults != null : !((Object)this$permCheckResults).equals(other$permCheckResults)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$UUID = this.getUUID();
        UUID other$UUID = other.getUUID();
        if (this$UUID == null ? other$UUID != null : !((Object)this$UUID).equals(other$UUID)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<String> this$perms = this.getPerms();
        List<String> other$perms = other.getPerms();
        if (this$perms == null ? other$perms != null : !((Object)this$perms).equals(other$perms)) {
            return false;
        }
        Map<String, Server> this$servers = this.getServers();
        Map<String, Server> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        String this$display = this.getDisplay();
        String other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        return this.getLastAccess() == other.getLastAccess();
    }

    public boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Map<String, List<String>> $cachedPerms = this.getCachedPerms();
        result = result * 31 + ($cachedPerms == null ? 0 : ((Object)$cachedPerms).hashCode());
        Map<String, Map<String, Map<String, Boolean>>> $permCheckResults = this.getPermCheckResults();
        result = result * 31 + ($permCheckResults == null ? 0 : ((Object)$permCheckResults).hashCode());
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        UUID $UUID = this.getUUID();
        result = result * 31 + ($UUID == null ? 0 : ((Object)$UUID).hashCode());
        List<Group> $groups = this.getGroups();
        result = result * 31 + ($groups == null ? 0 : ((Object)$groups).hashCode());
        List<String> $perms = this.getPerms();
        result = result * 31 + ($perms == null ? 0 : ((Object)$perms).hashCode());
        Map<String, Server> $servers = this.getServers();
        result = result * 31 + ($servers == null ? 0 : ((Object)$servers).hashCode());
        String $display = this.getDisplay();
        result = result * 31 + ($display == null ? 0 : $display.hashCode());
        String $prefix = this.getPrefix();
        result = result * 31 + ($prefix == null ? 0 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 31 + ($suffix == null ? 0 : $suffix.hashCode());
        long $lastAccess = this.getLastAccess();
        result = result * 31 + (int)($lastAccess >>> 32 ^ $lastAccess);
        return result;
    }

    private Map<String, List<String>> getCachedPerms() {
        return this.cachedPerms;
    }

    private void setCachedPerms(Map<String, List<String>> cachedPerms) {
        this.cachedPerms = cachedPerms;
    }

    private Map<String, Map<String, Map<String, Boolean>>> getPermCheckResults() {
        return this.permCheckResults;
    }

    private void setPermCheckResults(Map<String, Map<String, Map<String, Boolean>>> permCheckResults) {
        this.permCheckResults = permCheckResults;
    }
}

