/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Debug;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Mysql;
import net.alpenblock.bungeeperms.PermEntity;
import net.alpenblock.bungeeperms.Permable;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.World;
import net.alpenblock.bungeeperms.io.BackEnd;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.mysql2.EntityType;
import net.alpenblock.bungeeperms.io.mysql2.MysqlPermEntity;
import net.alpenblock.bungeeperms.io.mysql2.MysqlPermsAdapter2;
import net.alpenblock.bungeeperms.io.mysql2.ValueEntry;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;

public class MySQL2BackEnd
implements BackEnd {
    private final PlatformPlugin plugin = BungeePerms.getInstance().getPlugin();
    private final BPConfig config = BungeePerms.getInstance().getConfig();
    private final Debug debug = BungeePerms.getInstance().getDebug();
    private final Mysql mysql = new Mysql(this.config.getConfig(), this.debug, "bungeeperms");
    private final MysqlPermsAdapter2 adapter;
    private final String table;

    public MySQL2BackEnd() {
        this.mysql.connect();
        this.table = this.config.getTablePrefix() + "permissions2";
        this.adapter = new MysqlPermsAdapter2(this.mysql, this.table);
        this.adapter.createTable();
    }

    @Override
    public BackEndType getType() {
        return BackEndType.MySQL2;
    }

    @Override
    public void load() {
    }

    @Override
    public List<Group> loadGroups() {
        ArrayList<Group> ret = new ArrayList<Group>();
        List<String> groups = this.adapter.getGroups();
        for (String g : groups) {
            Group group = this.loadGroup(g);
            ret.add(group);
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public List<User> loadUsers() {
        ArrayList<User> ret = new ArrayList<User>();
        List<String> users = this.adapter.getUsers();
        for (String u : users) {
            User user = BungeePerms.getInstance().getConfig().isUseUUIDs() ? this.loadUser(UUID.fromString(u)) : this.loadUser(u);
            ret.add(user);
        }
        return ret;
    }

    @Override
    public Group loadGroup(String group) {
        MysqlPermEntity mpe = this.adapter.getGroup(group);
        if (mpe.getName() == null) {
            return null;
        }
        List<String> inheritances = MySQL2BackEnd.getValues(mpe.getData("inheritances"));
        boolean isdefault = this.getFirstValue(mpe.getData("default"), false);
        int rank = this.getFirstValue(mpe.getData("rank"), 1000);
        int weight = this.getFirstValue(mpe.getData("weight"), 1000);
        String ladder = MySQL2BackEnd.getFirstValue(mpe.getData("ladder"), null, null, "default");
        Group g = new Group(mpe.getName(), inheritances, new ArrayList<String>(), new HashMap<String, Server>(), rank, weight, ladder, isdefault, null, null, null);
        MySQL2BackEnd.loadServerWorlds(mpe, g);
        return g;
    }

    @Override
    public User loadUser(String user) {
        MysqlPermEntity mpe = this.adapter.getUser(user);
        if (mpe.getName() == null) {
            return null;
        }
        List<String> sgroups = MySQL2BackEnd.getValues(mpe.getData("groups"));
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        UUID uuid = BungeePerms.getInstance().getPermissionsManager().getUUIDPlayerDB().getUUID(mpe.getName());
        User u = new User(mpe.getName(), uuid, lgroups, new ArrayList<String>(), new HashMap<String, Server>(), null, null, null);
        MySQL2BackEnd.loadServerWorlds(mpe, u);
        return u;
    }

    @Override
    public User loadUser(UUID user) {
        MysqlPermEntity mpe = this.adapter.getUser(user.toString());
        if (mpe.getName() == null) {
            return null;
        }
        List<String> sgroups = MySQL2BackEnd.getValues(mpe.getData("groups"));
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        String username = BungeePerms.getInstance().getPermissionsManager().getUUIDPlayerDB().getPlayerName(user);
        User u = new User(username, user, lgroups, new ArrayList<String>(), new HashMap<String, Server>(), null, null, null);
        MySQL2BackEnd.loadServerWorlds(mpe, u);
        return u;
    }

    @Override
    public int loadVersion() {
        MysqlPermEntity mpe = this.adapter.getVersion();
        int version = this.getFirstValue(mpe.getData("version"), 2);
        return version;
    }

    @Override
    public void saveVersion(int version, boolean savetodisk) {
        this.adapter.saveData("version", EntityType.Version, "version", this.mkValueList(this.mkList(String.valueOf(version)), null, null));
    }

    @Override
    public boolean isUserInDatabase(User user) {
        return this.adapter.isInBD(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User);
    }

    @Override
    public List<String> getRegisteredUsers() {
        return this.adapter.getUsers();
    }

    @Override
    public List<String> getGroupUsers(Group group) {
        return this.adapter.getGroupUsers(group.getName());
    }

    @Override
    public synchronized void saveUser(User user, boolean savetodisk) {
        if (BungeePerms.getInstance().getConfig().isSaveAllUsers() || !user.isNothingSpecial()) {
            this.saveUserGroups(user);
            this.saveUserPerms(user);
            this.saveUserDisplay(user, null, null);
            this.saveUserPrefix(user, null, null);
            this.saveUserSuffix(user, null, null);
            for (Map.Entry<String, Server> se : user.getServers().entrySet()) {
                this.saveUserPerServerPerms(user, se.getKey());
                this.saveUserDisplay(user, se.getKey(), null);
                this.saveUserPrefix(user, se.getKey(), null);
                this.saveUserSuffix(user, se.getKey(), null);
                for (Map.Entry<String, World> we : se.getValue().getWorlds().entrySet()) {
                    this.saveUserPerServerWorldPerms(user, se.getKey(), we.getKey());
                    this.saveUserDisplay(user, se.getKey(), we.getKey());
                    this.saveUserPrefix(user, se.getKey(), we.getKey());
                    this.saveUserSuffix(user, se.getKey(), we.getKey());
                }
            }
        }
    }

    @Override
    public synchronized void saveGroup(Group group, boolean savetodisk) {
        this.saveGroupInheritances(group);
        this.saveGroupPerms(group);
        this.saveGroupRank(group);
        this.saveGroupLadder(group);
        this.saveGroupDefault(group);
        this.saveGroupDisplay(group, null, null);
        this.saveGroupPrefix(group, null, null);
        this.saveGroupSuffix(group, null, null);
        for (Map.Entry<String, Server> se : group.getServers().entrySet()) {
            this.saveGroupPerServerPerms(group, se.getKey());
            this.saveGroupDisplay(group, se.getKey(), null);
            this.saveGroupPrefix(group, se.getKey(), null);
            this.saveGroupSuffix(group, se.getKey(), null);
            for (Map.Entry<String, World> we : se.getValue().getWorlds().entrySet()) {
                this.saveGroupPerServerWorldPerms(group, se.getKey(), we.getKey());
                this.saveGroupDisplay(group, se.getKey(), we.getKey());
                this.saveGroupPrefix(group, se.getKey(), we.getKey());
                this.saveGroupSuffix(group, se.getKey(), we.getKey());
            }
        }
    }

    @Override
    public synchronized void deleteUser(User user) {
        this.adapter.deleteEntity(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User);
    }

    @Override
    public synchronized void deleteGroup(Group group) {
        this.adapter.deleteEntity(group.getName(), EntityType.Group);
    }

    @Override
    public synchronized void saveUserGroups(User user) {
        ArrayList<String> savegroups = new ArrayList<String>();
        for (Group g : user.getGroups()) {
            savegroups.add(g.getName());
        }
        this.adapter.saveData(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User, "groups", this.mkValueList(savegroups, null, null));
    }

    @Override
    public synchronized void saveUserPerms(User user) {
        this.saveUserPerms(user, null, null);
    }

    @Override
    public synchronized void saveUserPerServerPerms(User user, String server) {
        server = Statics.toLower(server);
        this.saveUserPerms(user, server, null);
    }

    @Override
    public synchronized void saveUserPerServerWorldPerms(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        this.saveUserPerms(user, server, world);
    }

    public synchronized void saveUserPerms(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> perms = user.getPerms();
        if (server != null) {
            perms = user.getServer(server).getPerms();
            if (world != null) {
                perms = user.getServer(server).getWorld(world).getPerms();
            }
        }
        this.adapter.saveData(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User, "permissions", this.mkValueList(perms, server, world), server, world);
    }

    @Override
    public synchronized void saveUserDisplay(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String display = user.getDisplay();
        if (server != null) {
            display = user.getServer(server).getDisplay();
            if (world != null) {
                display = user.getServer(server).getWorld(world).getDisplay();
            }
        }
        this.adapter.saveData(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User, "display", this.mkList(new ValueEntry(display, server, world)), server, world);
    }

    @Override
    public synchronized void saveUserPrefix(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String prefix = user.getPrefix();
        if (server != null) {
            prefix = user.getServer(server).getPrefix();
            if (world != null) {
                prefix = user.getServer(server).getWorld(world).getPrefix();
            }
        }
        this.adapter.saveData(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User, "prefix", this.mkList(new ValueEntry(prefix, server, world)), server, world);
    }

    @Override
    public synchronized void saveUserSuffix(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String suffix = user.getSuffix();
        if (server != null) {
            suffix = user.getServer(server).getSuffix();
            if (world != null) {
                suffix = user.getServer(server).getWorld(world).getSuffix();
            }
        }
        this.adapter.saveData(BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName(), EntityType.User, "suffix", this.mkList(new ValueEntry(suffix, server, world)), server, world);
    }

    @Override
    public synchronized void saveGroupPerms(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "permissions", this.mkValueList(group.getPerms(), null, null), null, null);
    }

    @Override
    public synchronized void saveGroupPerServerPerms(Group group, String server) {
        server = Statics.toLower(server);
        this.adapter.saveData(group.getName(), EntityType.Group, "permissions", this.mkValueList(group.getServer(server).getPerms(), server, null), server, null);
    }

    @Override
    public synchronized void saveGroupPerServerWorldPerms(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        this.adapter.saveData(group.getName(), EntityType.Group, "permissions", this.mkValueList(group.getServer(server).getWorld(world).getPerms(), server, world), server, world);
    }

    @Override
    public synchronized void saveGroupInheritances(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "inheritances", this.mkValueList(group.getInheritances(), null, null));
    }

    @Override
    public synchronized void saveGroupLadder(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "ladder", this.mkList(new ValueEntry(group.getLadder(), null, null)));
    }

    @Override
    public synchronized void saveGroupRank(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "rank", this.mkList(new ValueEntry(String.valueOf(group.getRank()), null, null)));
    }

    @Override
    public synchronized void saveGroupWeight(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "weight", this.mkList(new ValueEntry(String.valueOf(group.getWeight()), null, null)));
    }

    @Override
    public synchronized void saveGroupDefault(Group group) {
        this.adapter.saveData(group.getName(), EntityType.Group, "default", this.mkList(new ValueEntry(String.valueOf(group.isDefault()), null, null)));
    }

    @Override
    public synchronized void saveGroupDisplay(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String display = group.getDisplay();
        if (server != null) {
            display = group.getServer(server).getDisplay();
            if (world != null) {
                display = group.getServer(server).getWorld(world).getDisplay();
            }
        }
        this.adapter.saveData(group.getName(), EntityType.Group, "display", this.mkList(new ValueEntry(display, server, world)), server, world);
    }

    @Override
    public synchronized void saveGroupPrefix(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String prefix = group.getPrefix();
        if (server != null) {
            prefix = group.getServer(server).getPrefix();
            if (world != null) {
                prefix = group.getServer(server).getWorld(world).getPrefix();
            }
        }
        this.adapter.saveData(group.getName(), EntityType.Group, "prefix", this.mkList(new ValueEntry(prefix, server, world)), server, world);
    }

    @Override
    public synchronized void saveGroupSuffix(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String suffix = group.getSuffix();
        if (server != null) {
            suffix = group.getServer(server).getSuffix();
            if (world != null) {
                suffix = group.getServer(server).getWorld(world).getSuffix();
            }
        }
        this.adapter.saveData(group.getName(), EntityType.Group, "suffix", this.mkList(new ValueEntry(suffix, server, world)), server, world);
    }

    @Override
    public synchronized void format(List<Group> groups, List<User> users, int version) {
        int i;
        this.clearDatabase();
        for (i = 0; i < groups.size(); ++i) {
            this.saveGroup(groups.get(i), false);
        }
        for (i = 0; i < users.size(); ++i) {
            this.saveUser(users.get(i), false);
        }
        this.saveVersion(version, false);
    }

    @Override
    public synchronized int cleanup(List<Group> groups, List<User> users, int version) {
        int i;
        int deleted = 0;
        this.clearDatabase();
        for (i = 0; i < groups.size(); ++i) {
            this.saveGroup(groups.get(i), false);
        }
        for (i = 0; i < users.size(); ++i) {
            User u = users.get(i);
            if (BungeePerms.getInstance().getConfig().isDeleteUsersOnCleanup() && u.isNothingSpecial() && this.plugin.getPlayer(u.getName()) == null && this.plugin.getPlayer(u.getUUID()) == null) {
                ++deleted;
                continue;
            }
            this.saveUser(users.get(i), false);
        }
        this.saveVersion(version, false);
        return deleted;
    }

    @Override
    public void clearDatabase() {
        this.adapter.clearTable(this.table);
        this.load();
    }

    @Override
    public void reloadGroup(Group group) {
        MysqlPermEntity mpe = this.adapter.getGroup(group.getName());
        List<String> inheritances = MySQL2BackEnd.getValues(mpe.getData("inheritances"));
        boolean isdefault = this.getFirstValue(mpe.getData("default"), false);
        int rank = this.getFirstValue(mpe.getData("rank"), 1000);
        int weight = this.getFirstValue(mpe.getData("weight"), 1000);
        String ladder = MySQL2BackEnd.getFirstValue(mpe.getData("ladder"), null, null, "default");
        group.setInheritances(inheritances);
        group.setIsdefault(isdefault);
        group.setRank(rank);
        group.setWeight(weight);
        group.setLadder(ladder);
        group.setPerms(new ArrayList<String>());
        group.setServers(new HashMap<String, Server>());
        group.setDisplay(null);
        group.setPrefix(null);
        group.setSuffix(null);
        MySQL2BackEnd.loadServerWorlds(mpe, group);
    }

    @Override
    public void reloadUser(User user) {
        MysqlPermEntity mpe = this.adapter.getUser(this.config.isUseUUIDs() ? user.getUUID().toString() : user.getName());
        List<String> sgroups = MySQL2BackEnd.getValues(mpe.getData("groups"));
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        user.setGroups(lgroups);
        user.setExtraPerms(new ArrayList<String>());
        user.setServers(new HashMap<String, Server>());
        user.setDisplay(null);
        user.setPrefix(null);
        user.setSuffix(null);
        MySQL2BackEnd.loadServerWorlds(mpe, user);
    }

    private static List<String> getValues(List<ValueEntry> values) {
        if (values == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (ValueEntry e : values) {
            ret.add(e.getValue());
        }
        return ret;
    }

    private static String getFirstValue(List<ValueEntry> values, String server, String world, String def) {
        if (values == null || values.isEmpty()) {
            return def;
        }
        for (ValueEntry e : values) {
            if ((server != null || e.getServer() != null) && (server == null || e.getServer() == null || !e.getServer().equalsIgnoreCase(server) || (world != null || e.getWorld() != null) && (world == null || e.getWorld() == null || !e.getWorld().equalsIgnoreCase(world)))) continue;
            return e.getValue();
        }
        return def;
    }

    private boolean getFirstValue(List<ValueEntry> values, boolean def) {
        if (values == null || values.isEmpty()) {
            return def;
        }
        try {
            return Boolean.parseBoolean(values.get(0).getValue());
        }
        catch (Exception e) {
            return def;
        }
    }

    private int getFirstValue(List<ValueEntry> values, int def) {
        if (values == null || values.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(values.get(0).getValue());
        }
        catch (Exception e) {
            return def;
        }
    }

    private <T> List<T> mkList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    private List<ValueEntry> mkValueList(List<String> values, String server, String world) {
        ArrayList<ValueEntry> l = new ArrayList<ValueEntry>();
        for (String s : values) {
            l.add(new ValueEntry(s, server, world));
        }
        return l;
    }

    static void loadServerWorlds(MysqlPermEntity mpe, PermEntity p) {
        Map<String, Map<String, Map<String, List<ValueEntry>>>> map = MySQL2BackEnd.mapServerWorlds(mpe, "permissions", "prefix", "suffix", "display");
        for (Map.Entry<String, Map<String, Map<String, List<ValueEntry>>>> keylvl : map.entrySet()) {
            for (Map.Entry<String, Map<String, List<ValueEntry>>> serverlvl : keylvl.getValue().entrySet()) {
                for (Map.Entry<String, List<ValueEntry>> worldlvl : serverlvl.getValue().entrySet()) {
                    Permable permable = p;
                    Server s = null;
                    World w = null;
                    if (serverlvl.getKey() != null) {
                        s = p.getServer(serverlvl.getKey());
                        permable = s;
                    }
                    if (worldlvl.getKey() != null) {
                        w = s.getWorld(worldlvl.getKey());
                        permable = w;
                    }
                    switch (keylvl.getKey()) {
                        case "permissions": {
                            permable.setPerms(MySQL2BackEnd.getValues(worldlvl.getValue()));
                            break;
                        }
                        case "prefix": {
                            permable.setPrefix(MySQL2BackEnd.getFirstValue(worldlvl.getValue(), serverlvl.getKey(), worldlvl.getKey(), null));
                            break;
                        }
                        case "suffix": {
                            permable.setSuffix(MySQL2BackEnd.getFirstValue(worldlvl.getValue(), serverlvl.getKey(), worldlvl.getKey(), null));
                            break;
                        }
                        case "display": {
                            permable.setDisplay(MySQL2BackEnd.getFirstValue(worldlvl.getValue(), serverlvl.getKey(), worldlvl.getKey(), null));
                            break;
                        }
                    }
                }
            }
        }
    }

    static Map<String, Map<String, Map<String, List<ValueEntry>>>> mapServerWorlds(MysqlPermEntity mpe, String ... keys) {
        HashMap<String, Map<String, Map<String, List<ValueEntry>>>> map = new HashMap<String, Map<String, Map<String, List<ValueEntry>>>>();
        for (String key : keys) {
            HashMap servermap = new HashMap();
            map.put(key, servermap);
            List<ValueEntry> data = mpe.getData(key);
            if (data == null) {
                data = new ArrayList<ValueEntry>();
            }
            for (ValueEntry d : data) {
                List<ValueEntry> valuelist;
                Map worldmap;
                String world;
                String server = Statics.toLower(d.getServer());
                String string = world = server == null ? null : Statics.toLower(d.getWorld());
                if (servermap.containsKey(server)) {
                    worldmap = (Map)servermap.get(server);
                } else {
                    worldmap = new HashMap();
                    servermap.put(server, worldmap);
                }
                if (worldmap.containsKey(world)) {
                    valuelist = (List)worldmap.get(world);
                } else {
                    valuelist = new ArrayList();
                    worldmap.put(world, valuelist);
                }
                valuelist.add(d);
            }
        }
        return map;
    }
}

