/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Debug;
import net.alpenblock.bungeeperms.Mysql;
import net.alpenblock.bungeeperms.io.UUIDPlayerDB;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;

public class MySQLUUIDPlayerDB
implements UUIDPlayerDB {
    private final BPConfig config = BungeePerms.getInstance().getConfig();
    private final Debug debug = BungeePerms.getInstance().getDebug();
    private final Mysql mysql = new Mysql(this.config.getConfig(), this.debug, "bungeeperms");
    private final String table;

    public MySQLUUIDPlayerDB() {
        this.mysql.connect();
        this.table = this.config.getTablePrefix() + "uuidplayer";
        this.createTable();
    }

    private void createTable() {
        if (!this.mysql.tableExists(this.table)) {
            String t = "CREATE TABLE `" + this.table + "` (" + "`id` INT( 64 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ," + "`uuid` VARCHAR( 40 ) NOT NULL UNIQUE KEY," + "`player` VARCHAR( 20 ) NOT NULL UNIQUE KEY" + ") ENGINE = MYISAM ;";
            this.mysql.runQuery(t);
        }
    }

    @Override
    public UUIDPlayerDBType getType() {
        return UUIDPlayerDBType.MySQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getUUID(String player) {
        UUID ret = null;
        ResultSet res = null;
        try {
            String q = "SELECT uuid FROM " + this.table + " WHERE player='" + player + "' ORDER BY id ASC LIMIT 1";
            res = this.mysql.returnQuery(q);
            if (res.last()) {
                ret = UUID.fromString(res.getString("uuid"));
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            this.debug.log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlayerName(UUID uuid) {
        String ret = null;
        ResultSet res = null;
        try {
            String q = "SELECT player FROM " + this.table + " WHERE uuid='" + uuid + "'";
            res = this.mysql.returnQuery(q);
            if (res.last()) {
                ret = res.getString("player");
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            this.debug.log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return ret;
    }

    @Override
    public void update(UUID uuid, String player) {
        this.mysql.runQuery("DELETE FROM " + this.table + " WHERE uuid='" + uuid + "' OR player='" + player + "'");
        this.mysql.runQuery("INSERT IGNORE INTO " + this.table + " (uuid, player) VALUES ('" + uuid + "', '" + player + "')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, String> getAll() {
        HashMap<UUID, String> ret = new HashMap<UUID, String>();
        ResultSet res = null;
        try {
            String q = "SELECT uuid, player FROM " + this.table;
            res = this.mysql.returnQuery(q);
            while (res.next()) {
                UUID uuid = UUID.fromString(res.getString("uuid"));
                String name = res.getString("player");
                ret.put(uuid, name);
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            this.debug.log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.mysql.runQuery("TRUNCATE " + this.table);
    }
}

