/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.World;
import net.alpenblock.bungeeperms.io.BackEnd;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;

public class YAMLBackEnd
implements BackEnd {
    private final String permspath;
    private Config permsconf;
    private final PlatformPlugin plugin = BungeePerms.getInstance().getPlugin();
    private final BPConfig config = BungeePerms.getInstance().getConfig();

    public YAMLBackEnd() {
        this.permspath = "/permissions.yml";
        this.checkPermFile();
        this.permsconf = new Config(this.plugin, this.permspath);
    }

    @Override
    public BackEndType getType() {
        return BackEndType.YAML;
    }

    @Override
    public void load() {
        this.permsconf.load();
    }

    @Override
    public List<Group> loadGroups() {
        ArrayList<Group> ret = new ArrayList<Group>();
        List<String> groups = this.permsconf.getSubNodes("groups");
        for (String g : groups) {
            ret.add(this.loadGroup(g));
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public List<User> loadUsers() {
        ArrayList<User> ret = new ArrayList<User>();
        List<String> users = this.permsconf.getSubNodes("users");
        for (String u : users) {
            User user = BungeePerms.getInstance().getConfig().isUseUUIDs() ? this.loadUser(UUID.fromString(u)) : this.loadUser(u);
            ret.add(user);
        }
        return ret;
    }

    @Override
    public Group loadGroup(String group) {
        List<String> inheritances = this.permsconf.getListString("groups." + group + ".inheritances", new ArrayList<String>());
        List<String> permissions = this.permsconf.getListString("groups." + group + ".permissions", new ArrayList<String>());
        boolean isdefault = this.permsconf.getBoolean("groups." + group + ".default", false);
        int rank = this.permsconf.getInt("groups." + group + ".rank", 1000);
        int weight = this.permsconf.getInt("groups." + group + ".weight", 1000);
        String ladder = this.permsconf.getString("groups." + group + ".ladder", "default");
        String display = this.permsconf.getString("groups." + group + ".display", null);
        String prefix = this.permsconf.getString("groups." + group + ".prefix", null);
        String suffix = this.permsconf.getString("groups." + group + ".suffix", null);
        HashMap<String, Server> servers = new HashMap<String, Server>();
        for (String server : this.permsconf.getSubNodes("groups." + group + ".servers")) {
            List<String> serverperms = this.permsconf.getListString("groups." + group + ".servers." + server + ".permissions", new ArrayList<String>());
            String sdisplay = this.permsconf.getString("groups." + group + ".servers." + server + ".display", null);
            String sprefix = this.permsconf.getString("groups." + group + ".servers." + server + ".prefix", null);
            String ssuffix = this.permsconf.getString("groups." + group + ".servers." + server + ".suffix", null);
            HashMap<String, World> worlds = new HashMap<String, World>();
            for (String world : this.permsconf.getSubNodes("groups." + group + ".servers." + server + ".worlds")) {
                List<String> worldperms = this.permsconf.getListString("groups." + group + ".servers." + server + ".worlds." + world + ".permissions", new ArrayList<String>());
                String wdisplay = this.permsconf.getString("groups." + group + ".servers." + server + ".worlds." + world + ".display", null);
                String wprefix = this.permsconf.getString("groups." + group + ".servers." + server + ".worlds." + world + ".prefix", null);
                String wsuffix = this.permsconf.getString("groups." + group + ".servers." + server + ".worlds." + world + ".suffix", null);
                World w = new World(Statics.toLower(world), worldperms, wdisplay, wprefix, wsuffix);
                worlds.put(Statics.toLower(world), w);
            }
            servers.put(Statics.toLower(server), new Server(Statics.toLower(server), serverperms, worlds, sdisplay, sprefix, ssuffix));
        }
        Group g = new Group(group, inheritances, permissions, servers, rank, weight, ladder, isdefault, display, prefix, suffix);
        return g;
    }

    @Override
    public User loadUser(String user) {
        if (!this.permsconf.keyExists("users." + user)) {
            return null;
        }
        List<String> sgroups = this.permsconf.getListString("users." + user + ".groups", new ArrayList<String>());
        List<String> perms = this.permsconf.getListString("users." + user + ".permissions", new ArrayList<String>());
        String display = this.permsconf.getString("users." + user + ".display", null);
        String prefix = this.permsconf.getString("users." + user + ".prefix", null);
        String suffix = this.permsconf.getString("users." + user + ".suffix", null);
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        HashMap<String, Server> servers = new HashMap<String, Server>();
        for (String server : this.permsconf.getSubNodes("users." + user + ".servers")) {
            List<String> serverperms = this.permsconf.getListString("users." + user + ".servers." + server + ".permissions", new ArrayList<String>());
            String sdisplay = this.permsconf.getString("users." + user + ".servers." + server + ".display", null);
            String sprefix = this.permsconf.getString("users." + user + ".servers." + server + ".prefix", null);
            String ssuffix = this.permsconf.getString("users." + user + ".servers." + server + ".suffix", null);
            HashMap<String, World> worlds = new HashMap<String, World>();
            for (String world : this.permsconf.getSubNodes("users." + user + ".servers." + server + ".worlds")) {
                List<String> worldperms = this.permsconf.getListString("users." + user + ".servers." + server + ".worlds." + world + ".permissions", new ArrayList<String>());
                String wdisplay = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".display", null);
                String wprefix = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".prefix", null);
                String wsuffix = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".suffix", null);
                World w = new World(Statics.toLower(world), worldperms, wdisplay, wprefix, wsuffix);
                worlds.put(Statics.toLower(world), w);
            }
            servers.put(Statics.toLower(server), new Server(Statics.toLower(server), serverperms, worlds, sdisplay, sprefix, ssuffix));
        }
        UUID uuid = BungeePerms.getInstance().getPermissionsManager().getUUIDPlayerDB().getUUID(user);
        User u = new User(user, uuid, lgroups, perms, servers, display, prefix, suffix);
        return u;
    }

    @Override
    public User loadUser(UUID user) {
        if (!this.permsconf.keyExists("users." + user)) {
            return null;
        }
        List<String> sgroups = this.permsconf.getListString("users." + user + ".groups", new ArrayList<String>());
        List<String> perms = this.permsconf.getListString("users." + user + ".permissions", new ArrayList<String>());
        String display = this.permsconf.getString("users." + user + ".display", null);
        String prefix = this.permsconf.getString("users." + user + ".prefix", null);
        String suffix = this.permsconf.getString("users." + user + ".suffix", null);
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        HashMap<String, Server> servers = new HashMap<String, Server>();
        for (String server : this.permsconf.getSubNodes("users." + user + ".servers")) {
            List<String> serverperms = this.permsconf.getListString("users." + user + ".servers." + server + ".permissions", new ArrayList<String>());
            String sdisplay = this.permsconf.getString("users." + user + ".servers." + server + ".display", null);
            String sprefix = this.permsconf.getString("users." + user + ".servers." + server + ".prefix", null);
            String ssuffix = this.permsconf.getString("users." + user + ".servers." + server + ".suffix", null);
            HashMap<String, World> worlds = new HashMap<String, World>();
            for (String world : this.permsconf.getSubNodes("users." + user + ".servers." + server + ".worlds")) {
                List<String> worldperms = this.permsconf.getListString("users." + user + ".servers." + server + ".worlds." + world + ".permissions", new ArrayList<String>());
                String wdisplay = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".display", null);
                String wprefix = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".prefix", null);
                String wsuffix = this.permsconf.getString("users." + user + ".servers." + server + ".worlds." + world + ".suffix", null);
                World w = new World(Statics.toLower(world), worldperms, wdisplay, wprefix, wsuffix);
                worlds.put(Statics.toLower(world), w);
            }
            servers.put(Statics.toLower(server), new Server(Statics.toLower(server), serverperms, worlds, sdisplay, sprefix, ssuffix));
        }
        String username = BungeePerms.getInstance().getPermissionsManager().getUUIDPlayerDB().getPlayerName(user);
        User u = new User(username, user, lgroups, perms, servers, display, prefix, suffix);
        return u;
    }

    @Override
    public int loadVersion() {
        return this.permsconf.getInt("version", 1);
    }

    @Override
    public void saveVersion(int version, boolean savetodisk) {
        this.permsconf.setInt("version", version);
        if (savetodisk) {
            this.permsconf.save();
        }
    }

    @Override
    public boolean isUserInDatabase(User user) {
        return this.permsconf.keyExists("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()));
    }

    private void checkPermFile() {
        File f = new File(this.plugin.getPluginFolder(), this.permspath);
        if (!f.isFile()) {
            BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.NO_PERM_FILE, new Object[0]));
        }
    }

    @Override
    public List<String> getRegisteredUsers() {
        return this.permsconf.getSubNodes("users");
    }

    @Override
    public List<String> getGroupUsers(Group group) {
        ArrayList<String> users = new ArrayList<String>();
        for (String user : this.permsconf.getSubNodes("users")) {
            if (!this.permsconf.getListString("users." + user + ".groups", new ArrayList<String>()).contains(group.getName())) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public synchronized void saveUser(User user, boolean savetodisk) {
        if (BungeePerms.getInstance().getConfig().isSaveAllUsers() || !user.isNothingSpecial()) {
            ArrayList<String> groups = new ArrayList<String>();
            for (Group g : user.getGroups()) {
                groups.add(g.getName());
            }
            String uname = BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName();
            this.permsconf.setListString("users." + uname + ".groups", groups);
            this.permsconf.setListString("users." + uname + ".permissions", user.getExtraPerms());
            for (Map.Entry<String, Server> se : user.getServers().entrySet()) {
                this.permsconf.setListString("users." + uname + ".servers." + se.getKey() + ".permissions", se.getValue().getPerms());
                this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".display", se.getValue().getDisplay());
                this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".prefix", se.getValue().getPrefix());
                this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".suffix", se.getValue().getSuffix());
                for (Map.Entry<String, World> we : se.getValue().getWorlds().entrySet()) {
                    this.permsconf.setListString("users." + uname + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".permissions", we.getValue().getPerms());
                    this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".display", we.getValue().getDisplay());
                    this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".prefix", we.getValue().getPrefix());
                    this.permsconf.setString("users." + uname + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".suffix", we.getValue().getSuffix());
                }
            }
        }
    }

    @Override
    public synchronized void saveGroup(Group group, boolean savetodisk) {
        this.permsconf.setListString("groups." + group.getName() + ".inheritances", group.getInheritances());
        this.permsconf.setListString("groups." + group.getName() + ".permissions", group.getPerms());
        this.permsconf.setInt("groups." + group.getName() + ".rank", group.getRank());
        this.permsconf.setString("groups." + group.getName() + ".ladder", group.getLadder());
        this.permsconf.setBool("groups." + group.getName() + ".default", group.isDefault());
        this.permsconf.setString("groups." + group.getName() + ".display", group.getDisplay());
        this.permsconf.setString("groups." + group.getName() + ".prefix", group.getPrefix());
        this.permsconf.setString("groups." + group.getName() + ".suffix", group.getSuffix());
        for (Map.Entry<String, Server> se : group.getServers().entrySet()) {
            this.permsconf.setListString("groups." + group.getName() + ".servers." + se.getKey() + ".permissions", se.getValue().getPerms());
            this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".display", se.getValue().getDisplay());
            this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".prefix", se.getValue().getPrefix());
            this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".suffix", se.getValue().getSuffix());
            for (Map.Entry<String, World> we : se.getValue().getWorlds().entrySet()) {
                this.permsconf.setListString("groups." + group.getName() + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".permissions", we.getValue().getPerms());
                this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".display", we.getValue().getDisplay());
                this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".prefix", we.getValue().getPrefix());
                this.permsconf.setString("groups." + group.getName() + ".servers." + se.getKey() + ".worlds." + we.getKey() + ".suffix", we.getValue().getSuffix());
            }
        }
        if (savetodisk) {
            this.permsconf.save();
        }
    }

    @Override
    public synchronized void deleteUser(User user) {
        this.permsconf.deleteNode("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()));
    }

    @Override
    public synchronized void deleteGroup(Group group) {
        this.permsconf.deleteNode("groups." + group.getName());
    }

    @Override
    public synchronized void saveUserGroups(User user) {
        ArrayList<String> savegroups = new ArrayList<String>();
        for (Group g : user.getGroups()) {
            savegroups.add(g.getName());
        }
        this.permsconf.setListStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + ".groups", savegroups);
    }

    @Override
    public synchronized void saveUserPerms(User user) {
        this.permsconf.setListStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + ".permissions", user.getExtraPerms());
    }

    @Override
    public synchronized void saveUserPerServerPerms(User user, String server) {
        server = Statics.toLower(server);
        this.permsconf.setListStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + ".servers." + server + ".permissions", user.getServer(server).getPerms());
    }

    @Override
    public synchronized void saveUserPerServerWorldPerms(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        this.permsconf.setListStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + ".servers." + server + ".worlds." + world + ".permissions", user.getServer(server).getWorld(world).getPerms());
    }

    @Override
    public synchronized void saveUserDisplay(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String display = user.getDisplay();
        if (server != null) {
            display = user.getServer(server).getDisplay();
            if (world != null) {
                display = user.getServer(server).getWorld(world).getDisplay();
            }
        }
        this.permsconf.setStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".display", display);
    }

    @Override
    public synchronized void saveUserPrefix(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String prefix = user.getPrefix();
        if (server != null) {
            prefix = user.getServer(server).getPrefix();
            if (world != null) {
                prefix = user.getServer(server).getWorld(world).getPrefix();
            }
        }
        this.permsconf.setStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".prefix", prefix);
    }

    @Override
    public synchronized void saveUserSuffix(User user, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String suffix = user.getSuffix();
        if (server != null) {
            suffix = user.getServer(server).getSuffix();
            if (world != null) {
                suffix = user.getServer(server).getWorld(world).getSuffix();
            }
        }
        this.permsconf.setStringAndSave("users." + (BungeePerms.getInstance().getConfig().isUseUUIDs() ? user.getUUID().toString() : user.getName()) + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".suffix", suffix);
    }

    @Override
    public synchronized void saveGroupPerms(Group group) {
        this.permsconf.setListStringAndSave("groups." + group.getName() + ".permissions", group.getPerms());
    }

    @Override
    public synchronized void saveGroupPerServerPerms(Group group, String server) {
        server = Statics.toLower(server);
        this.permsconf.setListStringAndSave("groups." + group.getName() + ".servers." + server + ".permissions", group.getServer(server).getPerms());
    }

    @Override
    public synchronized void saveGroupPerServerWorldPerms(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        this.permsconf.setListStringAndSave("groups." + group.getName() + ".servers." + server + ".worlds." + world + ".permissions", group.getServer(server).getWorld(world).getPerms());
    }

    @Override
    public synchronized void saveGroupInheritances(Group group) {
        this.permsconf.setListStringAndSave("groups." + group.getName() + ".inheritances", group.getInheritances());
    }

    @Override
    public synchronized void saveGroupLadder(Group group) {
        this.permsconf.setStringAndSave("groups." + group.getName() + ".ladder", group.getLadder());
    }

    @Override
    public synchronized void saveGroupRank(Group group) {
        this.permsconf.setIntAndSave("groups." + group.getName() + ".rank", group.getRank());
    }

    @Override
    public synchronized void saveGroupWeight(Group group) {
        this.permsconf.setIntAndSave("groups." + group.getName() + ".weight", group.getWeight());
    }

    @Override
    public synchronized void saveGroupDefault(Group group) {
        this.permsconf.setBoolAndSave("groups." + group.getName() + ".default", group.isDefault());
    }

    @Override
    public synchronized void saveGroupDisplay(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String display = group.getDisplay();
        if (server != null) {
            display = group.getServer(server).getDisplay();
            if (world != null) {
                display = group.getServer(server).getWorld(world).getDisplay();
            }
        }
        this.permsconf.setStringAndSave("groups." + group.getName() + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".display", display);
    }

    @Override
    public synchronized void saveGroupPrefix(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String prefix = group.getPrefix();
        if (server != null) {
            prefix = group.getServer(server).getPrefix();
            if (world != null) {
                prefix = group.getServer(server).getWorld(world).getPrefix();
            }
        }
        this.permsconf.setStringAndSave("groups." + group.getName() + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".prefix", prefix);
    }

    @Override
    public synchronized void saveGroupSuffix(Group group, String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        String suffix = group.getSuffix();
        if (server != null) {
            suffix = group.getServer(server).getSuffix();
            if (world != null) {
                suffix = group.getServer(server).getWorld(world).getSuffix();
            }
        }
        this.permsconf.setStringAndSave("groups." + group.getName() + (server != null ? ".servers." + server + (world != null ? ".worlds." + world : "") : "") + ".suffix", suffix);
    }

    @Override
    public synchronized void format(List<Group> groups, List<User> users, int version) {
        int i;
        this.clearDatabase();
        for (i = 0; i < groups.size(); ++i) {
            this.saveGroup(groups.get(i), false);
        }
        for (i = 0; i < users.size(); ++i) {
            this.saveUser(users.get(i), false);
        }
        this.saveVersion(version, false);
        this.permsconf.save();
    }

    @Override
    public synchronized int cleanup(List<Group> groups, List<User> users, int version) {
        int i;
        int deleted = 0;
        this.clearDatabase();
        for (i = 0; i < groups.size(); ++i) {
            this.saveGroup(groups.get(i), false);
        }
        for (i = 0; i < users.size(); ++i) {
            User u = users.get(i);
            if (BungeePerms.getInstance().getConfig().isDeleteUsersOnCleanup() && u.isNothingSpecial() && BungeePerms.getInstance().getPlugin().getPlayer(u.getName()) == null && BungeePerms.getInstance().getPlugin().getPlayer(u.getUUID()) == null) {
                ++deleted;
                continue;
            }
            this.saveUser(users.get(i), false);
        }
        this.saveVersion(version, false);
        this.permsconf.save();
        return deleted;
    }

    @Override
    public void clearDatabase() {
        new File(BungeePerms.getInstance().getPlugin().getPluginFolder() + this.permspath).delete();
        this.permsconf = new Config(BungeePerms.getInstance().getPlugin(), this.permspath);
        this.load();
    }

    @Override
    public void reloadGroup(Group group) {
        this.permsconf.load();
        List<String> inheritances = this.permsconf.getListString("groups." + group.getName() + ".inheritances", new ArrayList<String>());
        List<String> permissions = this.permsconf.getListString("groups." + group.getName() + ".permissions", new ArrayList<String>());
        boolean isdefault = this.permsconf.getBoolean("groups." + group.getName() + ".default", false);
        int rank = this.permsconf.getInt("groups." + group.getName() + ".rank", 1000);
        int weight = this.permsconf.getInt("groups." + group.getName() + ".weight", 1000);
        String ladder = this.permsconf.getString("groups." + group.getName() + ".ladder", "default");
        String display = this.permsconf.getString("groups." + group.getName() + ".display", null);
        String prefix = this.permsconf.getString("groups." + group.getName() + ".prefix", null);
        String suffix = this.permsconf.getString("groups." + group.getName() + ".suffix", null);
        HashMap<String, Server> servers = new HashMap<String, Server>();
        for (String server : this.permsconf.getSubNodes("groups." + group.getName() + ".servers")) {
            List<String> serverperms = this.permsconf.getListString("groups." + group.getName() + ".servers." + server + ".permissions", new ArrayList<String>());
            String sdisplay = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".display", null);
            String sprefix = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".prefix", null);
            String ssuffix = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".suffix", null);
            HashMap<String, World> worlds = new HashMap<String, World>();
            for (String world : this.permsconf.getSubNodes("groups." + group.getName() + ".servers." + server + ".worlds")) {
                List<String> worldperms = this.permsconf.getListString("groups." + group.getName() + ".servers." + server + ".worlds." + world + ".permissions", new ArrayList<String>());
                String wdisplay = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".worlds." + world + ".display", null);
                String wprefix = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".worlds." + world + ".prefix", null);
                String wsuffix = this.permsconf.getString("groups." + group.getName() + ".servers." + server + ".worlds." + world + ".suffix", null);
                World w = new World(Statics.toLower(world), worldperms, wdisplay, wprefix, wsuffix);
                worlds.put(Statics.toLower(world), w);
            }
            servers.put(Statics.toLower(server), new Server(Statics.toLower(server), serverperms, worlds, sdisplay, sprefix, ssuffix));
        }
        group.setInheritances(inheritances);
        group.setPerms(permissions);
        group.setIsdefault(isdefault);
        group.setRank(rank);
        group.setWeight(weight);
        group.setLadder(ladder);
        group.setDisplay(display);
        group.setPrefix(prefix);
        group.setSuffix(suffix);
        group.setServers(servers);
    }

    @Override
    public void reloadUser(User user) {
        this.permsconf.load();
        String uname = this.config.isUseUUIDs() ? user.getUUID().toString() : user.getName();
        List<String> sgroups = this.permsconf.getListString("users." + uname + ".groups", new ArrayList<String>());
        List<String> perms = this.permsconf.getListString("users." + uname + ".permissions", new ArrayList<String>());
        String display = this.permsconf.getString("users." + uname + ".display", null);
        String prefix = this.permsconf.getString("users." + uname + ".prefix", null);
        String suffix = this.permsconf.getString("users." + uname + ".suffix", null);
        ArrayList<Group> lgroups = new ArrayList<Group>();
        for (String s : sgroups) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(s);
            if (g == null) continue;
            lgroups.add(g);
        }
        HashMap<String, Server> servers = new HashMap<String, Server>();
        for (String server : this.permsconf.getSubNodes("users." + uname + ".servers")) {
            List<String> serverperms = this.permsconf.getListString("users." + uname + ".servers." + server + ".permissions", new ArrayList<String>());
            String sdisplay = this.permsconf.getString("users." + uname + ".servers." + server + ".display", null);
            String sprefix = this.permsconf.getString("users." + uname + ".servers." + server + ".prefix", null);
            String ssuffix = this.permsconf.getString("users." + uname + ".servers." + server + ".suffix", null);
            HashMap<String, World> worlds = new HashMap<String, World>();
            for (String world : this.permsconf.getSubNodes("users." + uname + ".servers." + server + ".worlds")) {
                List<String> worldperms = this.permsconf.getListString("users." + uname + ".servers." + server + ".worlds." + world + ".permissions", new ArrayList<String>());
                String wdisplay = this.permsconf.getString("users." + uname + ".servers." + server + ".worlds." + world + ".display", null);
                String wprefix = this.permsconf.getString("users." + uname + ".servers." + server + ".worlds." + world + ".prefix", null);
                String wsuffix = this.permsconf.getString("users." + uname + ".servers." + server + ".worlds." + world + ".suffix", null);
                World w = new World(Statics.toLower(world), worldperms, wdisplay, wprefix, wsuffix);
                worlds.put(Statics.toLower(world), w);
            }
            servers.put(Statics.toLower(server), new Server(Statics.toLower(server), serverperms, worlds, sdisplay, sprefix, ssuffix));
        }
        user.setGroups(lgroups);
        user.setExtraPerms(perms);
        user.setDisplay(display);
        user.setPrefix(prefix);
        user.setSuffix(suffix);
        user.setServers(servers);
    }
}

