/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.io.UUIDPlayerDB;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;

public class YAMLUUIDPlayerDB
implements UUIDPlayerDB {
    private Config uuidconf = new Config(BungeePerms.getInstance().getPlugin(), "/uuidplayerdb.yml");

    public YAMLUUIDPlayerDB() {
        this.uuidconf.load();
    }

    @Override
    public UUIDPlayerDBType getType() {
        return UUIDPlayerDBType.YAML;
    }

    @Override
    public UUID getUUID(String player) {
        UUID ret = null;
        for (String uuid : this.uuidconf.getSubNodes("")) {
            String p = this.uuidconf.getString(uuid, "");
            if (!p.equalsIgnoreCase(player)) continue;
            ret = UUID.fromString(uuid);
        }
        return ret;
    }

    @Override
    public String getPlayerName(UUID uuid) {
        String ret = null;
        for (String suuid : this.uuidconf.getSubNodes("")) {
            if (!suuid.equalsIgnoreCase(uuid.toString())) continue;
            ret = this.uuidconf.getString(suuid, "");
        }
        return ret;
    }

    @Override
    public void update(UUID uuid, String player) {
        for (String suuid : this.uuidconf.getSubNodes("")) {
            if (!suuid.equalsIgnoreCase(uuid.toString()) && !this.uuidconf.getString(suuid, "").equalsIgnoreCase(player)) continue;
            this.uuidconf.deleteNode(suuid);
        }
        this.uuidconf.setStringAndSave(uuid.toString(), player);
    }

    @Override
    public Map<UUID, String> getAll() {
        HashMap<UUID, String> ret = new HashMap<UUID, String>();
        for (String suuid : this.uuidconf.getSubNodes("")) {
            ret.put(UUID.fromString(suuid), this.uuidconf.getString(suuid, ""));
        }
        return ret;
    }

    @Override
    public void clear() {
        new File(BungeePerms.getInstance().getPlugin().getPluginFolder(), "/uuidplayerdb.yml").delete();
        this.uuidconf = new Config(BungeePerms.getInstance().getPlugin(), "/uuidplayerdb.yml");
        this.uuidconf.load();
    }
}

