/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io.migrate;

import java.util.List;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.YAMLBackEnd;
import net.alpenblock.bungeeperms.io.migrate.Migrator;

public class Migrate2YAML
implements Migrator {
    private final BPConfig config;

    public Migrate2YAML(BPConfig conf) {
        this.config = conf;
    }

    @Override
    public void migrate(List<Group> groups, List<User> users, int permsversion) {
        YAMLBackEnd be = new YAMLBackEnd();
        be.clearDatabase();
        for (Group group : groups) {
            be.saveGroup(group, false);
        }
        for (User user : users) {
            be.saveUser(user, false);
        }
        be.saveVersion(permsversion, true);
        this.config.setBackendType(BackEndType.YAML);
        BungeePerms.getInstance().getPermissionsManager().setBackEnd(be);
    }
}

