/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io.mysql2;

import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.alpenblock.bungeeperms.Mysql;
import net.alpenblock.bungeeperms.io.mysql2.EntityType;
import net.alpenblock.bungeeperms.io.mysql2.ValueEntry;

public class MysqlPermEntity {
    private String name;
    private EntityType type;
    private final Map<String, List<ValueEntry>> data;

    public MysqlPermEntity(ResultSet res) throws SQLException {
        this.data = new HashMap<String, List<ValueEntry>>();
        this.load(res);
    }

    private void load(ResultSet res) throws SQLException {
        if (res.first()) {
            this.name = Mysql.unescape(res.getString("name"));
            this.type = EntityType.getByCode(res.getInt("type"));
        }
        res.beforeFirst();
        while (res.next()) {
            String key = Mysql.unescape(res.getString("key"));
            String value = Mysql.unescape(res.getString("value"));
            String server = Mysql.unescape(res.getString("server"));
            String world = null;
            if (server != null) {
                world = Mysql.unescape(res.getString("world"));
            }
            ValueEntry ve = new ValueEntry(value, server, world);
            List<ValueEntry> e = this.data.get(key);
            if (e == null) {
                e = new ArrayList<ValueEntry>();
                this.data.put(key, e);
            }
            e.add(ve);
        }
    }

    public List<ValueEntry> getData(String type) {
        return this.data.get(type);
    }

    public String getName() {
        return this.name;
    }

    public EntityType getType() {
        return this.type;
    }

    public Map<String, List<ValueEntry>> getData() {
        return this.data;
    }

    @ConstructorProperties(value={"name", "type", "data"})
    public MysqlPermEntity(String name, EntityType type, Map<String, List<ValueEntry>> data) {
        this.name = name;
        this.type = type;
        this.data = data;
    }
}

