/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.io.mysql2;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Mysql;
import net.alpenblock.bungeeperms.io.mysql2.EntityType;
import net.alpenblock.bungeeperms.io.mysql2.MysqlPermEntity;
import net.alpenblock.bungeeperms.io.mysql2.ValueEntry;

public class MysqlPermsAdapter2 {
    private final Mysql mysql;
    private final String table;

    public MysqlPermsAdapter2(Mysql m, String table) {
        this.mysql = m;
        this.table = table;
    }

    public void createTable() {
        if (!this.mysql.tableExists(this.table)) {
            String t = "CREATE TABLE `" + this.table + "` (" + "`id` INT( 64 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ," + "`name` VARCHAR( 64 ) NOT NULL ," + "`type` TINYINT( 2 ) NOT NULL ," + "`key` VARCHAR( 256 ) NOT NULL, " + "`value` VARCHAR( 256 ) NOT NULL, " + "`server` VARCHAR( 64 ), " + "`world` VARCHAR( 64 ) " + ") ENGINE = MYISAM ;";
            this.mysql.runQuery(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT DISTINCT `name` FROM `" + this.table + "` WHERE `type`=" + EntityType.Group.getCode() + " ORDER BY id ASC");
            while (res.next()) {
                String name = Mysql.unescape(res.getString("name"));
                groups.add(name);
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUsers() {
        ArrayList<String> groups = new ArrayList<String>();
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT DISTINCT `name` FROM `" + this.table + "` WHERE `type`=" + EntityType.User.getCode() + " ORDER BY id ASC");
            while (res.next()) {
                String name = Mysql.unescape(res.getString("name"));
                groups.add(name);
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MysqlPermEntity getEntity(String name, EntityType type) {
        MysqlPermEntity mpe = null;
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT `name`,`type`,`key`,`value`,`server`,`world` FROM `" + this.table + "` " + "WHERE `type`=" + type.getCode() + " AND `name`='" + Mysql.escape(name) + "' ORDER BY id ASC");
            mpe = new MysqlPermEntity(res);
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return mpe;
    }

    public MysqlPermEntity getGroup(String name) {
        return this.getEntity(name, EntityType.Group);
    }

    public MysqlPermEntity getUser(String name) {
        return this.getEntity(name, EntityType.User);
    }

    public MysqlPermEntity getVersion() {
        return this.getEntity("version", EntityType.Version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInBD(String name, EntityType type) {
        boolean found = false;
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT DISTINCT `name` FROM `" + this.table + "` WHERE `name`='" + Mysql.escape(name) + "' AND `type`=" + type.getCode() + " ORDER BY id ASC");
            if (res.next()) {
                found = true;
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
            found = false;
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return found;
    }

    public void deleteEntity(String name, EntityType type) {
        this.mysql.runQuery("DELETE FROM `" + this.table + "` WHERE `name`='" + Mysql.escape(name) + "' AND `type`=" + type.getCode());
    }

    public void saveData(String name, EntityType type, String key, List<ValueEntry> values) {
        String delq = "DELETE FROM `" + this.table + "` WHERE `name`='" + Mysql.escape(name) + "' AND `type`=" + type.getCode() + " AND `key`='" + Mysql.escape(key) + "'";
        this.mysql.runQuery(delq);
        this.doSaveData(name, type, key, values);
    }

    public void saveData(String name, EntityType type, String key, List<ValueEntry> values, String server, String world) {
        String delq = "DELETE FROM `" + this.table + "` WHERE `name`='" + Mysql.escape(name) + "' AND `type`=" + type.getCode() + " AND `key`='" + Mysql.escape(key) + "' AND ";
        delq = server == null ? delq + "`server` IS NULL" : delq + "`server`='" + Mysql.escape(server) + "'";
        delq = delq + " AND ";
        delq = world == null ? delq + "`world` IS NULL" : delq + "`world`='" + Mysql.escape(world) + "'";
        this.mysql.runQuery(delq);
        this.doSaveData(name, type, key, values);
    }

    private void doSaveData(String name, EntityType type, String key, List<ValueEntry> values) {
        for (ValueEntry val : values) {
            if (val.getValue() == null) continue;
            String insq = "INSERT INTO `" + this.table + "` (`name`,`type`,`key`,`value`,`server`,`world`) VALUES" + "('" + Mysql.escape(name) + "'," + type.getCode() + ",'" + Mysql.escape(key) + "','" + Mysql.escape(val.getValue()) + "',";
            if (val.getServer() == null) {
                insq = insq + "null,null";
            } else {
                insq = insq + "'" + Mysql.escape(val.getServer()) + "',";
                insq = val.getWorld() == null ? insq + "null" : insq + "'" + Mysql.escape(val.getWorld()) + "'";
            }
            insq = insq + ")";
            this.mysql.runQuery(insq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupUsers(String group) {
        ArrayList<String> groups = new ArrayList<String>();
        ResultSet res = null;
        try {
            res = this.mysql.returnQuery("SELECT DISTINCT `name` FROM `" + this.table + "` WHERE `type`=" + EntityType.User.getCode() + " AND `key`='groups' AND `value`='" + Mysql.escape(group) + "' ORDER BY id ASC");
            while (res.next()) {
                String name = Mysql.unescape(res.getString("name"));
                groups.add(name);
            }
            Mysql.closeResultSet(res);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
        finally {
            Mysql.closeResultSet(res);
        }
        return groups;
    }

    public void clearTable(String table) {
        this.mysql.runQuery("TRUNCATE `" + table + "`");
    }
}

