/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitSender;
import net.alpenblock.bungeeperms.platform.bukkit.Injector;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class BPPermissible
extends PermissibleBase {
    private CommandSender sender;
    private PermissionAttachment attachment;
    private Map<String, PermissionAttachmentInfo> permissions;
    private Map<String, PermissionAttachmentInfo> superperms;
    private Permissible oldPermissible = null;
    private ServerOperator oldOpable = null;
    private ServerOperator opable = null;
    private boolean opdisabled = false;
    private boolean init = false;

    public BPPermissible(CommandSender sender, User u, Permissible oldPermissible) {
        super((ServerOperator)sender);
        this.sender = sender;
        this.oldPermissible = oldPermissible;
        this.permissions = new LinkedHashMap<String, PermissionAttachmentInfo>(){

            @Override
            public PermissionAttachmentInfo put(String k, PermissionAttachmentInfo v) {
                PermissionAttachmentInfo existing = (PermissionAttachmentInfo)this.get(k);
                if (existing != null) {
                    return existing;
                }
                return super.put(k, v);
            }
        };
        this.superperms = new LinkedHashMap<String, PermissionAttachmentInfo>(){

            @Override
            public PermissionAttachmentInfo put(String k, PermissionAttachmentInfo v) {
                PermissionAttachmentInfo existing = (PermissionAttachmentInfo)this.get(k);
                if (existing != null) {
                    return existing;
                }
                return super.put(k, v);
            }
        };
        this.oldOpable = Statics.getField(PermissibleBase.class, oldPermissible, ServerOperator.class, "opable");
        this.opable = new ServerOperator(){

            public boolean isOp() {
                BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
                if (BPPermissible.this.opdisabled && !config.isAllowops()) {
                    return false;
                }
                if (config.isDebug()) {
                    BungeePerms.getLogger().info("op check: " + BPPermissible.this.sender.getName() + " has OP: " + BPPermissible.this.oldOpable.isOp());
                }
                return BPPermissible.this.oldOpable.isOp();
            }

            public void setOp(boolean value) {
                BPPermissible.this.oldOpable.setOp(value);
            }
        };
        this.init = true;
        this.recalculatePermissions();
    }

    public boolean hasSuperPerm(String perm) {
        if (this.oldPermissible == null) {
            return false;
        }
        return this.oldPermissible.hasPermission(perm);
    }

    public boolean hasPermission(String permission) {
        boolean res = BungeePerms.getInstance().getPermissionsChecker().hasPermOrConsoleOnServerInWorld(new BukkitSender(this.sender), permission);
        return res;
    }

    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission.getName());
    }

    public void recalculatePermissions() {
        block11: {
            Sender s;
            User u;
            if (!this.init) {
                return;
            }
            this.opdisabled = true;
            this.oldPermissible.recalculatePermissions();
            this.opdisabled = false;
            this.permissions.clear();
            this.permissions.putAll(this.superperms);
            BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
            User user = u = config.isUseUUIDs() && this.sender instanceof Player ? BungeePerms.getInstance().getPermissionsManager().getUser(((Player)this.sender).getUniqueId()) : BungeePerms.getInstance().getPermissionsManager().getUser(this.sender.getName());
            if (u != null) {
                u.flushCache();
            }
            if (!config.isSuperpermscompat()) break block11;
            if (!(this.sender instanceof Player)) {
                return;
            }
            Sender sender = s = config.isUseUUIDs() ? BungeePerms.getInstance().getPlugin().getPlayer(((Player)this.sender).getUniqueId()) : BungeePerms.getInstance().getPlugin().getPlayer(this.sender.getName());
            if (u == null || s == null) {
                return;
            }
            List<String> perms = u.getEffectivePerms(s.getServer(), s.getWorld());
            List<PermissionAttachmentInfo> childperms = this.addChildPerms(perms);
            if (!config.isUseRegexPerms()) {
                for (PermissionAttachmentInfo pai : childperms) {
                    boolean found;
                    if (pai.getPermission().endsWith("*")) {
                        found = false;
                        String regex = "^" + pai.getPermission().toLowerCase().replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*") + "$";
                        Pattern pat = Pattern.compile(regex);
                        for (Map.Entry<String, PermissionAttachmentInfo> e : this.permissions.entrySet()) {
                            if (!pat.matcher(e.getKey().toLowerCase()).find()) continue;
                            Statics.setField(e.getValue(), pai.getValue(), "value");
                            if (!e.getKey().equalsIgnoreCase(pai.getPermission())) continue;
                            found = true;
                        }
                        if (found) continue;
                        this.permissions.put(pai.getPermission(), pai);
                        continue;
                    }
                    found = false;
                    for (Map.Entry<String, PermissionAttachmentInfo> e : this.permissions.entrySet()) {
                        if (!e.getKey().equalsIgnoreCase(pai.getPermission())) continue;
                        Statics.setField(e.getValue(), pai.getValue(), "value");
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.permissions.put(pai.getPermission(), pai);
                }
            } else {
                for (PermissionAttachmentInfo pai : childperms) {
                    this.permissions.put(pai.getPermission(), pai);
                }
            }
        }
    }

    private List<PermissionAttachmentInfo> addChildPerms(List<String> perms) {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        for (String perm : perms) {
            map.put(perm.startsWith("-") ? perm.substring(1) : perm, !perm.startsWith("-"));
        }
        return this.addChildPerms(map);
    }

    private List<PermissionAttachmentInfo> addChildPerms(Map<String, Boolean> perms) {
        LinkedList<PermissionAttachmentInfo> permlist = new LinkedList<PermissionAttachmentInfo>();
        for (Map.Entry<String, Boolean> perm : perms.entrySet()) {
            PermissionAttachmentInfo pai = new PermissionAttachmentInfo(this.oldPermissible, perm.getKey().toLowerCase(), null, perm.getValue().booleanValue());
            permlist.add(pai);
            Permission permission = Bukkit.getPluginManager().getPermission(pai.getPermission());
            if (permission == null || permission.getChildren().isEmpty()) continue;
            permlist.addAll(this.addChildPerms(permission.getChildren()));
        }
        return permlist;
    }

    public Set<PermissionAttachmentInfo> getEffectiveSuperPerms() {
        return new LinkedHashSet<PermissionAttachmentInfo>(this.superperms.values());
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return new LinkedHashSet<PermissionAttachmentInfo>(this.permissions.values());
    }

    public boolean isOp() {
        return this.oldPermissible.isOp();
    }

    public void setOp(boolean value) {
        this.oldPermissible.setOp(value);
    }

    public boolean isPermissionSet(String permission) {
        return true;
    }

    public boolean isPermissionSet(Permission perm) {
        return true;
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.oldPermissible.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.oldPermissible.addAttachment(plugin, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.oldPermissible.addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.oldPermissible.addAttachment(plugin, name, value, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        this.oldPermissible.removeAttachment(attachment);
    }

    public synchronized void clearPermissions() {
        if (this.oldPermissible instanceof PermissibleBase) {
            PermissibleBase base = (PermissibleBase)this.oldPermissible;
            base.clearPermissions();
        }
    }

    public void updateAttachment(User u, String server, String world) {
        if (this.attachment == null) {
            this.attachment = this.addAttachment((Plugin)BukkitPlugin.getInstance());
            this.attachment.setPermission(this.getUserNodeName(u), true);
        }
        Permission perm = this.getUserNode(u);
        this.recalculatePermissions();
    }

    public void removeAttachment() {
        if (this.attachment != null) {
            this.removeAttachment(this.attachment);
            this.attachment.remove();
        }
    }

    private Permission getUserNode(User u) {
        String permname = this.getUserNodeName(u);
        Permission perm = Bukkit.getPluginManager().getPermission(permname);
        if (perm == null) {
            perm = new Permission(permname, "Internal permission for BungeePerms. DO NOT SET DIRECTLY", PermissionDefault.FALSE){

                public void recalculatePermissibles() {
                }
            };
            Bukkit.getPluginManager().addPermission(perm);
        }
        return perm;
    }

    private String getUserNodeName(User u) {
        if (this.sender instanceof ConsoleCommandSender) {
            return "bungeeperms.console";
        }
        String id = BungeePerms.getInstance().getConfig().isUseUUIDs() ? u.getUUID().toString() : u.getName();
        return "bungeeperms.user." + id;
    }

    public void inject() {
        if (Injector.getPermissible(this.sender) == this) {
            return;
        }
        Statics.setField(PermissibleBase.class, this.oldPermissible, this.superperms, "permissions");
        Statics.setField(PermissibleBase.class, (Object)this, this.permissions, "permissions");
        Statics.setField(PermissibleBase.class, this.oldPermissible, this.opable, "opable");
        Injector.inject(this.sender, (Permissible)this);
        this.recalculatePermissions();
    }

    public void uninject() {
        if (Injector.getPermissible(this.sender) != this) {
            return;
        }
        Statics.setField(PermissibleBase.class, this.oldPermissible, new HashMap(), "permissions");
        Statics.setField(PermissibleBase.class, this.oldPermissible, this.oldOpable, "opable");
        Injector.inject(this.sender, this.oldPermissible);
        this.recalculatePermissions();
    }

    public Permissible getOldPermissible() {
        return this.oldPermissible;
    }
}

