/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;
import net.alpenblock.bungeeperms.platform.EventListener;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BPPermissible;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.alpenblock.bungeeperms.platform.bukkit.Injector;
import net.alpenblock.bungeeperms.platform.bukkit.event.BungeePermsUserChangedEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitEventListener
implements Listener,
EventListener,
PluginMessageListener {
    private final Map<String, String> playerWorlds = new HashMap<String, String>();
    private boolean enabled = false;
    private final BukkitConfig config;

    public BukkitEventListener(BukkitConfig config) {
        this.config = config;
    }

    @Override
    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BukkitPlugin.getInstance());
        BPPermissible permissible = new BPPermissible((CommandSender)Bukkit.getConsoleSender(), null, Injector.getPermissible((CommandSender)Bukkit.getConsoleSender()));
        permissible.inject();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!(Injector.getPermissible((CommandSender)p) instanceof BPPermissible)) {
                User u = this.config.isUseUUIDs() ? this.pm().getUser(p.getUniqueId()) : this.pm().getUser(p.getName());
                BPPermissible perm = new BPPermissible((CommandSender)p, u, Injector.getPermissible((CommandSender)p));
                perm.inject();
            }
            p.recalculatePermissions();
        }
    }

    @Override
    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        Statics.unregisterListener(this);
        Injector.uninject((CommandSender)Bukkit.getConsoleSender());
        for (Player p : Bukkit.getOnlinePlayers()) {
            Injector.uninject((CommandSender)p);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLogin(PlayerLoginEvent e) {
        User u;
        User oldu;
        String playername = e.getPlayer().getName();
        UUID uuid = null;
        if (this.config.isUseUUIDs()) {
            uuid = e.getPlayer().getUniqueId();
            BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.LOGIN_UUID, playername, uuid));
            this.pm().getUUIDPlayerDB().update(uuid, playername);
        } else {
            BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.LOGIN, e.getPlayer().getName()));
        }
        User user = oldu = this.config.isUseUUIDs() ? this.pm().getUser(uuid, false) : this.pm().getUser(playername, false);
        if (oldu != null) {
            this.pm().removeUserFromCache(oldu);
        }
        User user2 = u = this.config.isUseUUIDs() ? this.pm().getUser(uuid) : this.pm().getUser(playername);
        if (u == null) {
            if (this.config.isUseUUIDs()) {
                BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.ADDING_DEFAULT_GROUPS_UUID, playername, uuid));
            } else {
                BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.ADDING_DEFAULT_GROUPS, playername));
            }
            u = this.pm().createTempUser(playername, uuid);
            this.pm().getBackEnd().saveUser(u, true);
        }
        BukkitPlugin.getInstance().getNotifier().sendWorldUpdate(e.getPlayer());
        BPPermissible permissible = new BPPermissible((CommandSender)e.getPlayer(), u, Injector.getPermissible((CommandSender)e.getPlayer()));
        permissible.inject();
        this.updateAttachment(e.getPlayer(), u);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        BukkitPlugin.getInstance().getNotifier().sendWorldUpdate(e.getPlayer());
        User u = this.config.isUseUUIDs() ? this.pm().getUser(e.getPlayer().getUniqueId()) : this.pm().getUser(e.getPlayer().getName());
        this.updateAttachment(e.getPlayer(), u);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        Injector.uninject((CommandSender)e.getPlayer());
        User u = this.config.isUseUUIDs() ? this.pm().getUser(e.getPlayer().getUniqueId()) : this.pm().getUser(e.getPlayer().getName());
        this.pm().removeUserFromCache(u);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangedWorld(PlayerChangedWorldEvent e) {
        BukkitPlugin.getInstance().getNotifier().sendWorldUpdate(e.getPlayer());
        User u = this.config.isUseUUIDs() ? this.pm().getUser(e.getPlayer().getUniqueId()) : this.pm().getUser(e.getPlayer().getName());
        this.updateAttachment(e.getPlayer(), u);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onUserUpdate(BungeePermsUserChangedEvent e) {
        Player p;
        Player player = p = this.config.isUseUUIDs() ? Bukkit.getPlayer((UUID)e.getUser().getUUID()) : Bukkit.getPlayer((String)e.getUser().getName());
        if (p == null) {
            return;
        }
        this.updateAttachment(p, e.getUser());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPluginChannelRegister(PlayerRegisterChannelEvent e) {
        if (!e.getChannel().equals("bungeeperms")) {
            return;
        }
        BukkitPlugin.getInstance().getNotifier().sendWorldUpdate(e.getPlayer());
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        String userorgroup;
        if (this.config.isStandalone()) {
            BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_STANDALONE, new Object[0]));
            BungeePerms.getInstance().getDebug().log(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_STANDALONE, new Object[0]));
            BungeePerms.getInstance().getDebug().log("sender = BungeeCord");
            BungeePerms.getInstance().getDebug().log("msg = " + new String(bytes));
            return;
        }
        String msg = new String(bytes);
        if (this.config.isDebug()) {
            BungeePerms.getLogger().info("msg=" + msg);
        }
        List<String> data = Statics.toList(msg, ";");
        String cmd = data.get(0);
        String string = userorgroup = data.size() > 1 ? data.get(1) : null;
        if (cmd.equalsIgnoreCase("deleteuser")) {
            User u = this.pm().getUser(userorgroup);
            this.pm().removeUserFromCache(u);
        } else if (cmd.equalsIgnoreCase("deletegroup")) {
            Group g = this.pm().getGroup(userorgroup);
            this.pm().removeGroupFromCache(g);
            for (Group gr : this.pm().getGroups()) {
                gr.recalcPerms();
            }
            for (User u : this.pm().getUsers()) {
                u.recalcPerms();
            }
        } else if (cmd.equalsIgnoreCase("reloaduser")) {
            this.pm().reloadUser(userorgroup);
        } else if (cmd.equalsIgnoreCase("reloadgroup")) {
            this.pm().reloadGroup(userorgroup);
        } else if (cmd.equalsIgnoreCase("reloadusers")) {
            this.pm().reloadUsers();
        } else if (cmd.equalsIgnoreCase("reloadgroups")) {
            this.pm().reloadGroups();
        } else if (cmd.equalsIgnoreCase("reloadall")) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BungeePerms.getInstance().reload(false);
                }
            };
            Bukkit.getScheduler().runTaskLater((Plugin)BukkitPlugin.getInstance(), r, 1L);
        } else if (cmd.equalsIgnoreCase("configcheck")) {
            String servername = data.get(1);
            BackEndType backend = BackEndType.getByName(data.get(2));
            UUIDPlayerDBType uuidplayerdb = UUIDPlayerDBType.getByName(data.get(3));
            boolean useuuid = Boolean.parseBoolean(data.get(4));
            if (!this.config.getServername().equals(servername)) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_SERVERNAME, new Object[0]));
            }
            if (this.config.getBackEndType() != backend) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_BACKEND, new Object[0]));
            }
            if (this.config.getUUIDPlayerDBType() != uuidplayerdb) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_UUIDPLAYERDB, new Object[0]));
            }
            if (this.config.isUseUUIDs() != useuuid) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUKKIT_USEUUID, new Object[0]));
            }
        } else if (cmd.equalsIgnoreCase("uuidcheck")) {
            if (!this.config.isUseUUIDs()) {
                return;
            }
            String uuid = data.get(2);
            Sender p = BukkitPlugin.getInstance().getPlayer(userorgroup);
            if (p != null && !p.getUUID().equals(UUID.fromString(uuid))) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEECORD_BUKKIT_CONFIG, new Object[0]));
            }
        }
    }

    private PermissionsManager pm() {
        return BungeePerms.getInstance().getPermissionsManager();
    }

    private void updateAttachment(Player p, User u) {
        Permissible base = Injector.getPermissible((CommandSender)p);
        if (!(base instanceof BPPermissible)) {
            return;
        }
        BPPermissible perm = (BPPermissible)base;
        perm.updateAttachment(u, ((BukkitConfig)BungeePerms.getInstance().getConfig()).getServername(), p.getWorld() == null ? null : p.getWorld().getName());
    }

    public Map<String, String> getPlayerWorlds() {
        return this.playerWorlds;
    }
}

