/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.beans.ConstructorProperties;
import java.util.UUID;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.NetworkNotifier;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BukkitNotifier
implements NetworkNotifier {
    private final BukkitConfig config;
    private long lastConfigUpdate = 0L;

    @Override
    public void deleteUser(User u, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        if (this.config.isUseUUIDs()) {
            this.sendPM(u.getUUID(), "deleteUser;" + u.getUUID(), origin);
        } else {
            this.sendPM(u.getName(), "deleteUser;" + u.getName(), origin);
        }
    }

    @Override
    public void deleteGroup(Group g, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        this.sendPMAll("deleteGroup;" + g.getName(), origin);
    }

    @Override
    public void reloadUser(User u, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        if (this.config.isUseUUIDs()) {
            this.sendPM(u.getUUID(), "reloadUser;" + u.getUUID(), origin);
        } else {
            this.sendPM(u.getName(), "reloadUser;" + u.getName(), origin);
        }
    }

    @Override
    public void reloadGroup(Group g, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        this.sendPMAll("reloadGroup;" + g.getName(), origin);
    }

    @Override
    public void reloadUsers(String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        this.sendPMAll("reloadUsers;", origin);
    }

    @Override
    public void reloadGroups(String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        this.sendPMAll("reloadGroups", origin);
    }

    @Override
    public void reloadAll(String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        this.sendPMAll("reloadall", origin);
    }

    private void sendPM(String player, String msg, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        Player p = Bukkit.getPlayer((String)player);
        if (p != null) {
            p.sendPluginMessage((Plugin)BukkitPlugin.getInstance(), "bungeeperms", msg.getBytes());
            this.sendConfig(p);
        } else {
            this.sendPMAll(msg, origin);
        }
    }

    private void sendPM(UUID player, String msg, String origin) {
        if (this.config.isStandalone()) {
            return;
        }
        Player p = Bukkit.getPlayer((UUID)player);
        if (p != null) {
            p.sendPluginMessage((Plugin)BukkitPlugin.getInstance(), "bungeeperms", msg.getBytes());
            this.sendConfig(p);
        } else {
            this.sendPMAll(msg, origin);
        }
    }

    private void sendPMAll(String msg, String origin) {
        Player p;
        if (this.config.isStandalone()) {
            return;
        }
        Player player = p = Bukkit.getOnlinePlayers().iterator().hasNext() ? (Player)Bukkit.getOnlinePlayers().iterator().next() : null;
        if (p != null) {
            p.sendPluginMessage((Plugin)BukkitPlugin.getInstance(), "bungeeperms", msg.getBytes());
            this.sendConfig(p);
        }
    }

    public void sendWorldUpdate(Player p) {
        if (this.config.isStandalone()) {
            return;
        }
        String world = p.getWorld() == null ? "" : p.getWorld().getName();
        p.sendPluginMessage((Plugin)BukkitPlugin.getInstance(), "bungeeperms", ("playerworldupdate;" + p.getName() + ";" + world).getBytes());
        this.sendConfig(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfig(Player p) {
        BukkitNotifier bukkitNotifier = this;
        synchronized (bukkitNotifier) {
            long now = System.currentTimeMillis();
            if (this.lastConfigUpdate + 300000L < now) {
                this.lastConfigUpdate = now;
                p.sendPluginMessage((Plugin)BukkitPlugin.getInstance(), "bungeeperms", ("configcheck;" + this.config.getServername() + ";" + (Object)((Object)this.config.getBackEndType()) + ";" + (Object)((Object)this.config.getUUIDPlayerDBType()) + ";" + this.config.isUseUUIDs()).getBytes());
            }
        }
    }

    @ConstructorProperties(value={"config"})
    public BukkitNotifier(BukkitConfig config) {
        this.config = config;
    }
}

