/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Color;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.PlatformType;
import net.alpenblock.bungeeperms.platform.PluginMessageSender;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitEventDispatcher;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitEventListener;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitMessageEncoder;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitNotifier;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPluginMessageSender;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitSender;
import net.alpenblock.bungeeperms.platform.bukkit.SuperPermsPreProcessor;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.BridgeManager;
import net.alpenblock.bungeeperms.platform.independend.GroupProcessor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitPlugin
extends JavaPlugin
implements PlatformPlugin {
    private static final double MILLI2TICK = (double)0.02f;
    private static BukkitPlugin instance;
    private BukkitConfig conf;
    private BukkitEventListener listener;
    private BukkitEventDispatcher dispatcher;
    private BukkitNotifier notifier;
    private PluginMessageSender pmsender;
    private BungeePerms bungeeperms;
    private final PlatformType platformType = PlatformType.Bukkit;
    private BridgeManager bridge;

    public void onLoad() {
        instance = this;
        Config config = new Config(this, "/config.yml");
        config.load();
        this.conf = new BukkitConfig(config);
        this.conf.load();
        this.loadcmds();
        this.listener = new BukkitEventListener(this.conf);
        this.dispatcher = new BukkitEventDispatcher();
        this.notifier = new BukkitNotifier(this.conf);
        this.pmsender = new BukkitPluginMessageSender();
        this.bungeeperms = new BungeePerms(this, this.conf, this.pmsender, this.notifier, this.listener, this.dispatcher);
        this.bungeeperms.load();
        this.bridge = new BridgeManager();
        this.bridge.load();
        this.bungeeperms.getPermissionsResolver().registerProcessor(new GroupProcessor());
        this.bungeeperms.getPermissionsResolver().registerProcessor(new SuperPermsPreProcessor());
    }

    public void onEnable() {
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "bungeeperms", (PluginMessageListener)this.listener);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "bungeeperms");
        this.bungeeperms.enable();
        this.bridge.enable();
    }

    public void onDisable() {
        this.bridge.disable();
        this.bungeeperms.disable();
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, "bungeeperms", (PluginMessageListener)this.listener);
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "bungeeperms");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        return this.bungeeperms.getCommandHandler().onCommand(new BukkitSender(sender), cmd.getName(), label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.conf.isTabComplete() || args.length == 0) {
            return l;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!Statics.toLower(p.getName()).startsWith(Statics.toLower(args[args.length - 1]))) continue;
            l.add(p.getName());
        }
        return l;
    }

    private void loadcmds() {
        Command command = new Command("bungeeperms"){

            public boolean execute(final CommandSender sender, final String alias, final String[] args) {
                final 1 cmd = this;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (!BukkitPlugin.this.onCommand(sender, cmd, alias, args)) {
                            sender.sendMessage((Object)((Object)Color.Error) + "[BungeePerms] Command not found");
                        }
                    }
                };
                if (BukkitPlugin.this.conf.isAsyncCommands()) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)instance, r);
                } else {
                    r.run();
                }
                return true;
            }
        };
        command.setAliases(Arrays.asList("bp"));
        command.setPermission(null);
        this.getCommandMap().register("bungeeperms", command);
    }

    private CommandMap getCommandMap() {
        try {
            Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            return (CommandMap)f.get(Bukkit.getPluginManager());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getPluginName() {
        return this.getDescription().getName();
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public String getAuthor() {
        return (String)this.getDescription().getAuthors().get(0);
    }

    @Override
    public String getPluginFolderPath() {
        return this.getDataFolder().getAbsolutePath();
    }

    @Override
    public File getPluginFolder() {
        return this.getDataFolder();
    }

    @Override
    public Sender getPlayer(String name) {
        Player sender = Bukkit.getPlayer((String)name);
        BukkitSender s = null;
        if (sender != null) {
            s = new BukkitSender((CommandSender)sender);
        }
        return s;
    }

    @Override
    public Sender getPlayer(UUID uuid) {
        Player sender = Bukkit.getPlayer((UUID)uuid);
        BukkitSender s = null;
        if (sender != null) {
            s = new BukkitSender((CommandSender)sender);
        }
        return s;
    }

    @Override
    public Sender getConsole() {
        return new BukkitSender((CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public List<Sender> getPlayers() {
        ArrayList<Sender> senders = new ArrayList<Sender>();
        for (Player pp : Bukkit.getOnlinePlayers()) {
            senders.add(new BukkitSender((CommandSender)pp));
        }
        return senders;
    }

    @Override
    public boolean isChatApiPresent() {
        try {
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public MessageEncoder newMessageEncoder() {
        return new BukkitMessageEncoder("");
    }

    @Override
    public int registerRepeatingTask(Runnable r, long delay, long interval) {
        return this.getServer().getScheduler().runTaskTimer((Plugin)this, r, (long)((double)delay * (double)0.02f), (long)((double)interval * (double)0.02f)).getTaskId();
    }

    @Override
    public void cancelTask(int id) {
        this.getServer().getScheduler().cancelTask(id);
    }

    public BukkitConfig getConf() {
        return this.conf;
    }

    public BukkitEventListener getListener() {
        return this.listener;
    }

    public BukkitEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public BukkitNotifier getNotifier() {
        return this.notifier;
    }

    public PluginMessageSender getPmsender() {
        return this.pmsender;
    }

    public BungeePerms getBungeeperms() {
        return this.bungeeperms;
    }

    @Override
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public static BukkitPlugin getInstance() {
        return instance;
    }

    public BridgeManager getBridge() {
        return this.bridge;
    }
}

