/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.beans.ConstructorProperties;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitMessageEncoder;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class BukkitSender
implements Sender {
    private final CommandSender sender;

    @Override
    public void sendMessage(String message) {
        this.sender.sendMessage(message);
    }

    @Override
    public void sendMessage(MessageEncoder encoder) {
        BukkitMessageEncoder e = (BukkitMessageEncoder)encoder;
        if (this.isPlayer() && BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            BaseComponent[] converted = BukkitMessageEncoder.convert(e.create());
            ((Player)this.sender).spigot().sendMessage(converted);
        } else {
            this.sender.sendMessage(e.toString());
        }
    }

    @Override
    public String getName() {
        return this.sender.getName();
    }

    @Override
    public UUID getUUID() {
        if (!BungeePerms.getInstance().getConfig().isUseUUIDs()) {
            throw new IllegalStateException("useuuid not enabled but uuid functionality called");
        }
        if (this.sender instanceof ConsoleCommandSender) {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        if (this.sender instanceof Player) {
            return ((Player)this.sender).getUniqueId();
        }
        return null;
    }

    @Override
    public String getServer() {
        if (this.sender instanceof Player) {
            return ((BukkitConfig)BungeePerms.getInstance().getConfig()).getServername();
        }
        return null;
    }

    @Override
    public String getWorld() {
        if (this.sender instanceof Player) {
            World w = ((Player)this.sender).getWorld();
            return w != null ? w.getName() : null;
        }
        return null;
    }

    @Override
    public boolean isConsole() {
        return this.sender instanceof ConsoleCommandSender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    @Override
    public boolean isOperator() {
        return this.isPlayer() && ((Player)this.sender).isOp();
    }

    public CommandSender getSender() {
        return this.sender;
    }

    @ConstructorProperties(value={"sender"})
    public BukkitSender(CommandSender sender) {
        this.sender = sender;
    }
}

