/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.lang.reflect.Field;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.platform.bukkit.BPPermissible;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class Injector {
    public static void inject(CommandSender sender, Permissible newpermissible) {
        try {
            Field perm = Injector.getPermField(sender);
            if (perm == null) {
                return;
            }
            perm.setAccessible(true);
            perm.set(sender, newpermissible);
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
    }

    public static void uninject(CommandSender sender) {
        Permissible perm = Injector.getPermissible(sender);
        if (perm instanceof BPPermissible) {
            BPPermissible p = (BPPermissible)perm;
            p.uninject();
        }
    }

    public static Permissible getPermissible(CommandSender sender) {
        try {
            Field perm = Injector.getPermField(sender);
            if (perm == null) {
                return null;
            }
            perm.setAccessible(true);
            Permissible permissible = (Permissible)perm.get(sender);
            return permissible;
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
            return null;
        }
    }

    private static Field getPermField(CommandSender sender) {
        Field perm = null;
        try {
            if (sender instanceof Player) {
                perm = Class.forName(Injector.getVersionedClassName("entity.CraftHumanEntity")).getDeclaredField("perm");
            } else if (sender instanceof ConsoleCommandSender) {
                perm = Class.forName(Injector.getVersionedClassName("command.ServerCommandSender")).getDeclaredField("perm");
            }
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
        }
        return perm;
    }

    private static String getVersionedClassName(String classname) {
        String version;
        Class<?> serverClass = Bukkit.getServer().getClass();
        if (!serverClass.getSimpleName().equals("CraftServer")) {
            return null;
        }
        if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            version = ".";
        } else {
            version = serverClass.getName().substring("org.bukkit.craftbukkit".length());
            version = version.substring(0, version.length() - "CraftServer".length());
        }
        return "org.bukkit.craftbukkit" + version + classname;
    }
}

