/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.alpenblock.bungeeperms.BPPermission;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsPreProcessor;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BPPermissible;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitSender;
import net.alpenblock.bungeeperms.platform.bukkit.Injector;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class SuperPermsPreProcessor
implements PermissionsPreProcessor {
    @Override
    public List<String> process(List<String> perms, Sender s) {
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        if (!config.isSuperpermscompat()) {
            return perms;
        }
        if (s != null) {
            perms.addAll(0, this.getSuperPerms(s));
        }
        this.expandChildPerms(perms);
        return perms;
    }

    private List<String> getSuperPerms(Sender s) {
        BukkitSender bs = (BukkitSender)s;
        CommandSender sender = bs.getSender();
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player p = (Player)sender;
        Permissible base = Injector.getPermissible((CommandSender)p);
        if (!(base instanceof BPPermissible)) {
            return new ArrayList<String>();
        }
        BPPermissible perm = (BPPermissible)base;
        ArrayList<String> l = new ArrayList<String>(perm.getEffectiveSuperPerms().size());
        for (PermissionAttachmentInfo e : perm.getEffectiveSuperPerms()) {
            l.add((e.getValue() ? "" : "-") + e.getPermission().toLowerCase());
        }
        return l;
    }

    private List<String> expandChildPerms(List<String> perms) {
        for (int i = 0; i < perms.size(); ++i) {
            String perm = perms.get(i);
            boolean neg = perm.startsWith("-");
            perm = neg ? perm.substring(1) : perm;
            Permission p = Bukkit.getPluginManager().getPermission(perm);
            if (p == null || p.getChildren().isEmpty()) continue;
            ArrayList<String> l = new ArrayList<String>();
            for (Map.Entry e : p.getChildren().entrySet()) {
                l.add(((Boolean)e.getValue() != false ? "" : "-") + ((String)e.getKey()).toLowerCase());
            }
            perms.addAll(i + 1, l);
        }
        return perms;
    }

    @Override
    public List<BPPermission> processWithOrigin(List<BPPermission> perms, Sender s) {
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        if (!config.isSuperpermscompat()) {
            return perms;
        }
        if (s != null) {
            List<String> l = this.getSuperPerms(s);
            for (int i = 0; i < l.size(); ++i) {
                perms.add(i, new BPPermission(l.get(i), "SuperPerms", true, null, null));
            }
        }
        this.expandChildPermsWithOrigin(perms);
        return perms;
    }

    private List<BPPermission> expandChildPermsWithOrigin(List<BPPermission> perms) {
        for (int i = 0; i < perms.size(); ++i) {
            String perm = perms.get(i).getPermission();
            boolean neg = perm.startsWith("-");
            perm = neg ? perm.substring(1) : perm;
            Permission p = Bukkit.getPluginManager().getPermission(perm);
            if (p == null || p.getChildren().isEmpty()) continue;
            ArrayList<BPPermission> l = new ArrayList<BPPermission>();
            for (Map.Entry e : p.getChildren().entrySet()) {
                l.add(new BPPermission(((Boolean)e.getValue() != false ? "" : "-") + ((String)e.getKey()).toLowerCase(), "SuperPerms child of " + perm, true, null, null));
            }
            perms.addAll(i + 1, l);
        }
        return perms;
    }
}

