/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.Bridge;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.essentials.EssentialsBridge;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.vault.VaultBridge;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.worldedit.WorldEditBridge;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class BridgeManager
implements Listener {
    private static BridgeManager instance;
    private Map<Class<? extends Bridge>, String> brigdesmap;
    private List<Bridge> bridges;

    public static BridgeManager getInstance() {
        return instance;
    }

    public void load() {
        instance = this;
        this.brigdesmap = new HashMap<Class<? extends Bridge>, String>();
        this.bridges = new ArrayList<Bridge>();
        this.brigdesmap.put(WorldEditBridge.class, "com.sk89q.worldedit.bukkit.WorldEditPlugin");
        this.brigdesmap.put(VaultBridge.class, "net.milkbowl.vault.Vault");
        this.brigdesmap.put(EssentialsBridge.class, "com.earth2me.essentials.Essentials");
        for (Map.Entry<Class<? extends Bridge>, String> entry : this.brigdesmap.entrySet()) {
            this.createBridge(entry.getKey(), entry.getValue());
        }
    }

    public void enable() {
        for (Bridge b : this.bridges) {
            b.enable();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BukkitPlugin.getInstance());
    }

    public void disable() {
        PluginEnableEvent.getHandlerList().unregister((Listener)this);
        for (Bridge b : this.bridges) {
            b.disable();
        }
    }

    public boolean onCommand(Sender sender, String cmd, String label, String[] args) {
        if (cmd.equalsIgnoreCase("bungeepermsbukkitbridge")) {
            if (!sender.isConsole()) {
                sender.sendMessage(ChatColor.DARK_RED + "Only console can do that!");
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.disable();
                this.enable();
            }
            return true;
        }
        return false;
    }

    public Bridge createBridge(Class<? extends Bridge> c, String classname) {
        try {
            Class.forName(classname);
            Bridge b = c.newInstance();
            this.bridges.add(b);
            return b;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        for (Map.Entry<Class<? extends Bridge>, String> entry : this.brigdesmap.entrySet()) {
            try {
                Class.forName(entry.getValue());
                for (Bridge b : this.bridges) {
                    if (!b.getClass().getName().equals(entry.getKey().getName())) continue;
                    throw new Exception();
                }
                this.createBridge(entry.getKey(), entry.getValue()).enable();
            }
            catch (Exception exception) {}
        }
    }

    @EventHandler
    public void onPluginEnable2(PluginEnableEvent e) {
        if (e.getPlugin().getName().equalsIgnoreCase("BungeePermsBukkitBridge")) {
            Bukkit.getConsoleSender().sendMessage(Color.RED + "WARNING: Please remove BungeePermsBukkitBridge!!! It's now integrated in BungeePermsBukkit.");
        }
    }
}

