/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.essentials;

import com.earth2me.essentials.perm.IPermissionsHandler;
import java.util.ArrayList;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class BungeePermsHandler
implements IPermissionsHandler {
    private final BungeePerms perms = BungeePerms.getInstance();

    public String getGroup(Player player) {
        User u = this.perms.getPermissionsManager().getUser(player.getName());
        if (u == null) {
            return "";
        }
        Group g = this.perms.getPermissionsManager().getMainGroup(u);
        return g == null ? "" : g.getName();
    }

    public List<String> getGroups(Player player) {
        ArrayList<String> groups = new ArrayList<String>();
        User u = this.perms.getPermissionsManager().getUser(player.getName());
        if (u == null) {
            return groups;
        }
        for (Group g : u.getGroups()) {
            groups.add(g.getName());
        }
        return groups;
    }

    public boolean canBuild(Player player, String group) {
        return true;
    }

    public boolean inGroup(Player player, String group) {
        User u = this.perms.getPermissionsManager().getUser(player.getName());
        if (u == null) {
            return false;
        }
        Group g = this.perms.getPermissionsManager().getGroup(group);
        if (g == null) {
            return false;
        }
        return u.getGroups().contains(g);
    }

    public boolean hasPermission(Player player, String node) {
        return this.perms.getPermissionsChecker().hasPermOrConsoleOnServerInWorld(new BukkitSender((CommandSender)player), Statics.toLower(node));
    }

    public String getPrefix(Player player) {
        User u = this.perms.getPermissionsManager().getUser(player.getName());
        if (u == null) {
            return "";
        }
        return u.buildPrefix(new BukkitSender((CommandSender)player));
    }

    public String getSuffix(Player player) {
        User u = this.perms.getPermissionsManager().getUser(player.getName());
        if (u == null) {
            return "";
        }
        return u.buildSuffix(new BukkitSender((CommandSender)player));
    }
}

