/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.vault;

import java.util.logging.Logger;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Chat_BungeePerms
extends Chat {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = BungeePerms.getInstance().getPlugin().getPluginName();
    private Plugin plugin;
    private BungeePerms perms;

    public Chat_BungeePerms(Plugin plugin, Permission perms) {
        super(perms);
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new ChatServerListener(), (Plugin)BukkitPlugin.getInstance());
        Plugin p = plugin.getServer().getPluginManager().getPlugin("BungeePerms");
        if (p != null) {
            this.perms = BungeePerms.getInstance();
            log.info(String.format("[%s][Chat] %s hooked.", plugin.getDescription().getName(), this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.perms != null && this.perms.isEnabled();
    }

    public String getPlayerPrefix(String world, String player) {
        User u = this.perms.getPermissionsManager().getUser(player);
        return u == null ? "" : u.buildPrefix();
    }

    public void setPlayerPrefix(String world, String player, String prefix) {
        prefix = prefix.replaceAll("&", "\u00a7");
        User u = this.perms.getPermissionsManager().getUser(player);
        if (u == null) {
            return;
        }
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        this.perms.getPermissionsManager().setUserPrefix(u, prefix, config.getServername(), world);
    }

    public String getPlayerSuffix(String world, String player) {
        User u = this.perms.getPermissionsManager().getUser(player);
        return u == null ? "" : u.buildSuffix();
    }

    public void setPlayerSuffix(String world, String player, String suffix) {
        suffix = suffix.replaceAll("&", "\u00a7");
        User u = this.perms.getPermissionsManager().getUser(player);
        if (u == null) {
            return;
        }
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        this.perms.getPermissionsManager().setUserSuffix(u, suffix, config.getServername(), world);
    }

    public String getGroupPrefix(String world, String group) {
        Group g = this.perms.getPermissionsManager().getGroup(group);
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        return g == null ? "" : g.buildPrefix(config.getServername(), world);
    }

    public void setGroupPrefix(String world, String group, String prefix) {
        prefix = prefix.replaceAll("&", "\u00a7");
        Group g = this.perms.getPermissionsManager().getGroup(group);
        if (g == null) {
            return;
        }
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        this.perms.getPermissionsManager().setGroupPrefix(g, prefix, config.getServername(), world);
    }

    public String getGroupSuffix(String world, String group) {
        Group g = this.perms.getPermissionsManager().getGroup(group);
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        return g == null ? "" : g.buildSuffix(config.getServername(), world);
    }

    public void setGroupSuffix(String world, String group, String suffix) {
        suffix = suffix.replaceAll("&", "\u00a7");
        Group g = this.perms.getPermissionsManager().getGroup(group);
        if (g == null) {
            return;
        }
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        this.perms.getPermissionsManager().setGroupSuffix(g, suffix, config.getServername(), world);
    }

    public int getPlayerInfoInteger(String world, String player, String node, int defaultValue) {
        return defaultValue;
    }

    public void setPlayerInfoInteger(String world, String player, String node, int value) {
    }

    public int getGroupInfoInteger(String world, String group, String node, int defaultValue) {
        return defaultValue;
    }

    public void setGroupInfoInteger(String world, String group, String node, int value) {
    }

    public double getPlayerInfoDouble(String world, String player, String node, double defaultValue) {
        return defaultValue;
    }

    public void setPlayerInfoDouble(String world, String player, String node, double value) {
    }

    public double getGroupInfoDouble(String world, String group, String node, double defaultValue) {
        return defaultValue;
    }

    public void setGroupInfoDouble(String world, String group, String node, double value) {
    }

    public boolean getPlayerInfoBoolean(String world, String player, String node, boolean defaultValue) {
        return defaultValue;
    }

    public void setPlayerInfoBoolean(String world, String player, String node, boolean value) {
    }

    public boolean getGroupInfoBoolean(String world, String group, String node, boolean defaultValue) {
        return defaultValue;
    }

    public void setGroupInfoBoolean(String world, String group, String node, boolean value) {
    }

    public String getPlayerInfoString(String world, String player, String node, String defaultValue) {
        return defaultValue;
    }

    public void setPlayerInfoString(String world, String player, String node, String value) {
    }

    public String getGroupInfoString(String world, String group, String node, String defaultValue) {
        return defaultValue;
    }

    public void setGroupInfoString(String world, String group, String node, String value) {
    }

    public class ChatServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin p;
            if (Chat_BungeePerms.this.perms == null && (p = event.getPlugin()).getDescription().getName().equals("BungeePerms")) {
                Chat_BungeePerms.this.perms = BungeePerms.getInstance();
                log.info(String.format("[%s][Chat] %s hooked.", Chat_BungeePerms.this.plugin.getDescription().getName(), Chat_BungeePerms.this.name));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            Plugin permPlugin;
            if (Chat_BungeePerms.this.perms != null && (permPlugin = event.getPlugin()).getDescription().getName().equals("BungeePerms")) {
                Chat_BungeePerms.this.perms = null;
                log.info(String.format("[%s][Chat] %s unhooked.", Chat_BungeePerms.this.plugin.getDescription().getName(), Chat_BungeePerms.this.name));
            }
        }
    }
}

