/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.vault;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.Bridge;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.vault.Chat_BungeePerms;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.vault.Permission_BungeePerms;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class VaultBridge
implements Bridge {
    @Override
    public void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BukkitPlugin.getInstance());
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Vault");
        if (plugin != null) {
            this.inject(plugin);
        }
    }

    @Override
    public void disable() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Vault");
        if (plugin != null) {
            this.uninject(plugin);
        }
        PluginEnableEvent.getHandlerList().unregister((Listener)this);
        PluginDisableEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        if (!e.getPlugin().getName().equalsIgnoreCase("vault")) {
            return;
        }
        this.inject(e.getPlugin());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent e) {
        if (!e.getPlugin().getName().equalsIgnoreCase("vault")) {
            return;
        }
        this.uninject(e.getPlugin());
    }

    public void inject(Plugin plugin) {
        BungeePerms.getLogger().info("Injection of Bungeeperms into Vault");
        try {
            Vault v = (Vault)plugin;
            if (!v.isEnabled()) {
                return;
            }
            Method m = v.getClass().getDeclaredMethod("hookPermission", String.class, Class.class, ServicePriority.class, String[].class);
            m.setAccessible(true);
            m.invoke((Object)v, "BungeePerms", Permission_BungeePerms.class, ServicePriority.Normal, new String[]{"net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin"});
            Field f = v.getClass().getDeclaredField("perms");
            f.setAccessible(true);
            f.set(v, Bukkit.getServicesManager().getRegistration(Permission.class).getProvider());
            m = v.getClass().getDeclaredMethod("hookChat", String.class, Class.class, ServicePriority.class, String[].class);
            m.setAccessible(true);
            m.invoke((Object)v, "BungeePerms", Chat_BungeePerms.class, ServicePriority.Normal, new String[]{"net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin"});
        }
        catch (Exception ex) {
            BungeePerms.getInstance().getDebug().log(ex);
        }
    }

    public void uninject(Plugin plugin) {
        BungeePerms.getLogger().info("Uninjection of Bungeeperms into Vault");
        try {
            Vault v = (Vault)plugin;
            if (!v.isEnabled()) {
                return;
            }
            Method m = v.getClass().getDeclaredMethod("loadChat", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)v, new Object[0]);
            m = v.getClass().getDeclaredMethod("loadPermission", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)v, new Object[0]);
        }
        catch (Exception ex) {
            BungeePerms.getInstance().getDebug().log(ex);
        }
    }
}

