/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.worldedit;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolver;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class BungeePermsResolver
implements PermissionsResolver {
    private final PermissionsManager manager;

    public static PermissionsResolver factory(Server server, YAMLProcessor config) {
        try {
            PermissionsManager manager = BungeePerms.getInstance().getPermissionsManager();
            if (manager == null) {
                return null;
            }
            return new BungeePermsResolver(server, manager);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public BungeePermsResolver(Server server, PermissionsManager manager) {
        this.manager = manager;
    }

    public boolean hasPermission(String player, String permission) {
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        return BungeePerms.getInstance().getPermissionsChecker().hasPermOnServer(player, Statics.toLower(permission), Statics.toLower(config.getServername()));
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        BukkitConfig config = (BukkitConfig)BungeePerms.getInstance().getConfig();
        return BungeePerms.getInstance().getPermissionsChecker().hasPermOnServerInWorld(name, Statics.toLower(permission), Statics.toLower(config.getServername()), Statics.toLower(worldName));
    }

    public boolean hasPermission(OfflinePlayer player, String permission) {
        return this.hasPermission(player.getName(), permission);
    }

    public boolean hasPermission(String worldName, OfflinePlayer player, String permission) {
        return this.hasPermission(worldName, player.getName(), permission);
    }

    public boolean inGroup(String player, String group) {
        return this.manager.getUser(player).getGroups().contains(BungeePerms.getInstance().getPermissionsManager().getGroup(group));
    }

    public boolean inGroup(OfflinePlayer player, String group) {
        return this.inGroup(player.getName(), group);
    }

    public String[] getGroups(String player) {
        User user = this.manager.getUser(player);
        if (user == null) {
            return new String[0];
        }
        List<String> groups = user.getGroupsString();
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getGroups(OfflinePlayer player) {
        return this.getGroups(player.getName());
    }

    public String getDetectionMessage() {
        String pluginname = BungeePerms.getInstance().getPlugin().getPluginName();
        return pluginname + " detected! Using " + pluginname + " for permissions.";
    }

    public void load() {
    }
}

