/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.worldedit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.lang.reflect.Field;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.Bridge;
import net.alpenblock.bungeeperms.platform.bukkit.bridge.bridges.worldedit.BungeePermsResolver;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class WorldEditBridge
implements Bridge {
    @Override
    public void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BukkitPlugin.getInstance());
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
        if (plugin != null) {
            this.inject(plugin);
        }
    }

    @Override
    public void disable() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
        if (plugin != null) {
            this.uninject(plugin);
        }
        PluginEnableEvent.getHandlerList().unregister((Listener)this);
        PluginDisableEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        if (!e.getPlugin().getName().equalsIgnoreCase("worldedit")) {
            return;
        }
        this.inject(e.getPlugin());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent e) {
        if (!e.getPlugin().getName().equalsIgnoreCase("worldedit")) {
            return;
        }
        this.uninject(e.getPlugin());
    }

    public void inject(Plugin plugin) {
        BungeePerms.getLogger().info("Injection of Bungeeperms into WorldEdit");
        try {
            WorldEditPlugin we = (WorldEditPlugin)plugin;
            if (!we.isEnabled()) {
                return;
            }
            Field f = we.getPermissionsResolver().getClass().getDeclaredField("enabledResolvers");
            f.setAccessible(true);
            ((List)f.get(we.getPermissionsResolver())).add(BungeePermsResolver.class);
            we.getPermissionsResolver().findResolver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void uninject(Plugin plugin) {
        BungeePerms.getLogger().info("Uninjection of Bungeeperms into WorldEdit");
        try {
            WorldEditPlugin we = (WorldEditPlugin)plugin;
            Field f = we.getPermissionsResolver().getClass().getDeclaredField("enabledResolvers");
            f.setAccessible(true);
            ((List)f.get(we.getPermissionsResolver())).remove(BungeePermsResolver.class);
            we.getPermissionsResolver().findResolver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

