/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.platform.bungee.NetworkType;

public class BungeeConfig
extends BPConfig {
    private NetworkType networkType;
    private List<String> networkServers;

    public BungeeConfig(Config config) {
        super(config);
    }

    @Override
    public void load() {
        super.load();
        this.networkType = this.config.getEnumValue("networktype", NetworkType.Global);
        if (this.networkType == NetworkType.ServerDependend || this.networkType == NetworkType.ServerDependendBlacklist) {
            this.networkServers = this.config.getListString("networkservers", Arrays.asList("lobby"));
        } else if (!this.config.keyExists("networkservers")) {
            this.config.setListString("networkservers", new ArrayList<String>());
        }
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public List<String> getNetworkServers() {
        return this.networkServers;
    }
}

