/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;
import net.alpenblock.bungeeperms.platform.EventListener;
import net.alpenblock.bungeeperms.platform.bungee.BungeeConfig;
import net.alpenblock.bungeeperms.platform.bungee.BungeePlugin;
import net.alpenblock.bungeeperms.platform.bungee.BungeeSender;
import net.alpenblock.bungeeperms.platform.bungee.NetworkType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeeEventListener
implements Listener,
EventListener {
    private final Map<String, String> playerWorlds = new HashMap<String, String>();
    private boolean enabled = false;
    private final BungeeConfig config;

    public BungeeEventListener(BungeeConfig config) {
        this.config = config;
    }

    @Override
    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)BungeePlugin.getInstance(), (Listener)this);
    }

    @Override
    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        ProxyServer.getInstance().getPluginManager().unregisterListener((Listener)this);
    }

    @EventHandler(priority=-127)
    public void onLogin(LoginEvent e) {
        User u;
        User oldu;
        if (e.isCancelled()) {
            return;
        }
        String playername = e.getConnection().getName();
        UUID uuid = null;
        if (this.config.isUseUUIDs()) {
            uuid = e.getConnection().getUniqueId();
            BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.LOGIN_UUID, playername, uuid));
            this.pm().getUUIDPlayerDB().update(uuid, playername);
        } else {
            BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.LOGIN, playername));
        }
        User user = oldu = this.config.isUseUUIDs() ? this.pm().getUser(uuid, false) : this.pm().getUser(playername, false);
        if (oldu != null) {
            this.pm().removeUserFromCache(oldu);
        }
        User user2 = u = this.config.isUseUUIDs() ? this.pm().getUser(uuid) : this.pm().getUser(playername);
        if (u == null) {
            if (this.config.isUseUUIDs()) {
                BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.ADDING_DEFAULT_GROUPS_UUID, playername, uuid));
            } else {
                BungeePerms.getLogger().info(Lang.translate(Lang.MessageType.ADDING_DEFAULT_GROUPS, playername));
            }
            u = this.pm().createTempUser(playername, uuid);
            this.pm().getBackEnd().saveUser(u, true);
        }
    }

    @EventHandler(priority=127)
    public void onDisconnect(PlayerDisconnectEvent e) {
        String playername = e.getPlayer().getName();
        UUID uuid = e.getPlayer().getUniqueId();
        User u = this.config.isUseUUIDs() ? this.pm().getUser(uuid) : this.pm().getUser(playername);
        this.pm().removeUserFromCache(u);
    }

    @EventHandler(priority=-128)
    public void onPermissionCheck(PermissionCheckEvent e) {
        CommandSender s = e.getSender();
        e.setHasPermission(BungeePerms.getInstance().getPermissionsChecker().hasPermOrConsoleOnServerInWorld(new BungeeSender(s), e.getPermission()));
    }

    @EventHandler(priority=-128)
    public void onTabcomplete(TabCompleteEvent e) {
        if (!this.config.isTabComplete()) {
            return;
        }
        if (e.getSuggestions().isEmpty()) {
            for (ProxiedPlayer pp : ProxyServer.getInstance().getPlayers()) {
                if (!Statics.toLower(pp.getName()).startsWith(Statics.toLower(e.getCursor()))) continue;
                e.getSuggestions().add(pp.getName());
            }
        }
    }

    @EventHandler(priority=-128)
    public void onServerConnected(final ServerConnectedEvent e) {
        this.playerWorlds.put(e.getPlayer().getName(), null);
        if (this.config.isUseUUIDs()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BungeePlugin.getInstance().getNotifier().sendUUIDAndPlayer(e.getPlayer().getName(), e.getPlayer().getUniqueId());
                }
            };
            ProxyServer.getInstance().getScheduler().schedule((Plugin)BungeePlugin.getInstance(), r, 1L, TimeUnit.SECONDS);
        }
    }

    @EventHandler(priority=-128)
    public void onMessage(PluginMessageEvent e) {
        String userorgroup;
        if (!e.getTag().equalsIgnoreCase("bungeeperms")) {
            return;
        }
        if (!(e.getReceiver() instanceof ProxiedPlayer)) {
            BungeePerms.getLogger().severe(Lang.translate(Lang.MessageType.INTRUSION_DETECTED, e.getSender()));
            e.setCancelled(true);
            return;
        }
        Server scon = (Server)e.getSender();
        if (this.config.getNetworkType() == NetworkType.Standalone) {
            BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_STANDALONE, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_STANDALONE, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log("sender = " + scon.getInfo().getName());
            BungeePerms.getInstance().getDebug().log("msg = " + new String(e.getData()));
            return;
        }
        if (this.config.getNetworkType() == NetworkType.ServerDependend && !this.config.getNetworkServers().contains(scon.getInfo().getName())) {
            BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_SERVERDEPENDEND, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_SERVERDEPENDEND, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log("sender = " + scon.getInfo().getName());
            BungeePerms.getInstance().getDebug().log("msg = " + new String(e.getData()));
            return;
        }
        if (this.config.getNetworkType() == NetworkType.ServerDependendBlacklist && this.config.getNetworkServers().contains(scon.getInfo().getName())) {
            BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_SERVERDEPENDENDBLACKLIST, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_SERVERDEPENDENDBLACKLIST, scon.getInfo().getName()));
            BungeePerms.getInstance().getDebug().log("sender = " + scon.getInfo().getName());
            BungeePerms.getInstance().getDebug().log("msg = " + new String(e.getData()));
            return;
        }
        String msg = new String(e.getData());
        if (this.config.isDebug()) {
            BungeePerms.getLogger().info("msg=" + msg);
        }
        List<String> data = Statics.toList(msg, ";");
        String cmd = data.get(0);
        String string = userorgroup = data.size() > 1 ? data.get(1) : null;
        if (cmd.equalsIgnoreCase("playerworldupdate")) {
            String world = data.get(2);
            this.playerWorlds.put(userorgroup, world);
        } else if (cmd.equalsIgnoreCase("deleteuser")) {
            User u = this.pm().getUser(userorgroup);
            this.pm().removeUserFromCache(u);
            BungeePerms.getInstance().getNetworkNotifier().deleteUser(u, scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("deletegroup")) {
            Group g = this.pm().getGroup(userorgroup);
            this.pm().removeGroupFromCache(g);
            for (Group gr : this.pm().getGroups()) {
                gr.recalcPerms();
            }
            for (User u : this.pm().getUsers()) {
                u.recalcPerms();
            }
            BungeePerms.getInstance().getNetworkNotifier().deleteGroup(g, scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("reloaduser")) {
            this.pm().reloadUser(userorgroup);
            User u = this.pm().getUser(userorgroup);
            if (u == null) {
                return;
            }
            BungeePerms.getInstance().getNetworkNotifier().reloadUser(u, scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("reloadgroup")) {
            this.pm().reloadGroup(userorgroup);
            Group g = this.pm().getGroup(userorgroup);
            if (g == null) {
                return;
            }
            BungeePerms.getInstance().getNetworkNotifier().reloadGroup(g, scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("reloadusers")) {
            this.pm().reloadUsers();
            BungeePerms.getInstance().getNetworkNotifier().reloadUsers(scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("reloadgroups")) {
            this.pm().reloadGroups();
            BungeePerms.getInstance().getNetworkNotifier().reloadGroups(scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("reloadall")) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BungeePerms.getInstance().reload(false);
                }
            };
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)BungeePlugin.getInstance(), r);
            BungeePerms.getInstance().getNetworkNotifier().reloadAll(scon.getInfo().getName());
        } else if (cmd.equalsIgnoreCase("configcheck")) {
            String servername = data.get(1);
            BackEndType backend = BackEndType.getByName(data.get(2));
            UUIDPlayerDBType uuidplayerdb = UUIDPlayerDBType.getByName(data.get(3));
            boolean useuuid = Boolean.parseBoolean(data.get(4));
            if (!scon.getInfo().getName().equals(servername)) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_SERVERNAME, scon.getInfo().getName()));
            }
            if (this.config.getBackEndType() != backend) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_BACKEND, scon.getInfo().getName()));
            }
            if (this.config.getUUIDPlayerDBType() != uuidplayerdb) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_UUIDPLAYERDB, scon.getInfo().getName()));
            }
            if (this.config.isUseUUIDs() != useuuid) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_BUNGEE_USEUUID, scon.getInfo().getName()));
            }
        }
        e.setCancelled(true);
    }

    private PermissionsManager pm() {
        return BungeePerms.getInstance().getPermissionsManager();
    }

    public Map<String, String> getPlayerWorlds() {
        return this.playerWorlds;
    }
}

