/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.util.ArrayList;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.ChatColor;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;

public class BungeeMessageEncoder
extends MessageEncoder {
    private ComponentBuilder builder;
    BaseComponent[] cache;
    private List<String> list;
    private String current;

    public static MessageEncoder.BaseComponent[] convert(BaseComponent[] components) {
        MessageEncoder.BaseComponent[] ret = new MessageEncoder.BaseComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            ret[i] = new MessageEncoder.BaseComponent(components[i]);
        }
        return ret;
    }

    public static BaseComponent[] convert(MessageEncoder.BaseComponent[] components) {
        BaseComponent[] ret = new BaseComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            ret[i] = (BaseComponent)components[i].getComponent();
        }
        return ret;
    }

    public BungeeMessageEncoder(MessageEncoder original) {
        super(original);
        if (!(original instanceof BungeeMessageEncoder)) {
            throw new IllegalArgumentException("original is not a BungeeMessageEncoder");
        }
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.builder = ((BungeeMessageEncoder)original).builder;
        }
        this.list = new ArrayList<String>(((BungeeMessageEncoder)original).list);
        this.current = ((BungeeMessageEncoder)original).current;
    }

    public BungeeMessageEncoder(String text) {
        super(text);
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.builder = new ComponentBuilder(text);
        }
        this.list = new ArrayList<String>();
        this.current = text;
    }

    @Override
    public MessageEncoder append(String text) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.append(text);
        }
        this.list.add(this.current);
        this.current = text;
        return this;
    }

    @Override
    public MessageEncoder color(ChatColor color) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.color(net.md_5.bungee.api.ChatColor.valueOf((String)color.name()));
        }
        this.current = (Object)((Object)color) + this.current;
        return this;
    }

    @Override
    public MessageEncoder bold(boolean bold) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.bold(bold);
        } else {
            this.color(ChatColor.BOLD);
            if (bold) {
                this.color(ChatColor.BOLD);
            }
            this.current = this.current.replaceAll("" + (Object)((Object)ChatColor.BOLD), "");
        }
        return this;
    }

    @Override
    public MessageEncoder italic(boolean italic) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.italic(italic);
        } else {
            this.color(ChatColor.ITALIC);
            if (italic) {
                this.color(ChatColor.ITALIC);
            }
            this.current = this.current.replaceAll("" + (Object)((Object)ChatColor.ITALIC), "");
        }
        return this;
    }

    @Override
    public MessageEncoder underlined(boolean underlined) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.underlined(underlined);
        } else {
            if (underlined) {
                this.color(ChatColor.UNDERLINE);
            }
            this.current = this.current.replaceAll("" + (Object)((Object)ChatColor.UNDERLINE), "");
        }
        return this;
    }

    @Override
    public MessageEncoder strikethrough(boolean strikethrough) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.strikethrough(strikethrough);
        } else {
            if (strikethrough) {
                this.color(ChatColor.STRIKETHROUGH);
            }
            this.current = this.current.replaceAll("" + (Object)((Object)ChatColor.STRIKETHROUGH), "");
        }
        return this;
    }

    @Override
    public MessageEncoder obfuscated(boolean obfuscated) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            this.cache = null;
            this.builder = this.builder.obfuscated(obfuscated);
        } else {
            if (obfuscated) {
                this.color(ChatColor.MAGIC);
            }
            this.current = this.current.replaceAll("" + (Object)((Object)ChatColor.MAGIC), "");
        }
        return this;
    }

    @Override
    public MessageEncoder event(MessageEncoder.ClickEvent clickEvent) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            if (clickEvent == null) {
                this.builder = this.builder.event((ClickEvent)null);
            } else {
                this.cache = null;
                ClickEvent.Action action = ClickEvent.Action.valueOf((String)clickEvent.getAction().name());
                this.builder = this.builder.event(new ClickEvent(action, clickEvent.getValue()));
            }
        }
        return this;
    }

    @Override
    public MessageEncoder event(MessageEncoder.HoverEvent hoverEvent) {
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            if (hoverEvent == null) {
                this.builder = this.builder.event((HoverEvent)null);
            } else {
                this.cache = null;
                HoverEvent.Action action = HoverEvent.Action.valueOf((String)hoverEvent.getAction().name());
                this.builder = this.builder.event(new HoverEvent(action, BungeeMessageEncoder.convert(hoverEvent.getValue().create())));
            }
        }
        return this;
    }

    @Override
    public MessageEncoder.BaseComponent[] create() {
        if (this.cache == null) {
            this.cache = this.builder.create();
        }
        return BungeeMessageEncoder.convert(this.cache);
    }

    public String toString() {
        String ret = "";
        for (String s : this.list) {
            ret = ret + s;
        }
        ret = ret + this.current;
        return ret;
    }
}

