/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.beans.ConstructorProperties;
import java.util.UUID;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.NetworkNotifier;
import net.alpenblock.bungeeperms.platform.bungee.BungeeConfig;
import net.alpenblock.bungeeperms.platform.bungee.NetworkType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeNotifier
implements NetworkNotifier {
    private final BungeeConfig config;
    private long lastConfigUpdate = 0L;

    @Override
    public void deleteUser(User u, String origin) {
        if (this.config.isUseUUIDs()) {
            this.sendPM(u.getUUID(), "deleteUser;" + u.getUUID(), origin);
        } else {
            this.sendPM(u.getName(), "deleteUser;" + u.getName(), origin);
        }
    }

    @Override
    public void deleteGroup(Group g, String origin) {
        this.sendPMAll("deleteGroup;" + g.getName(), origin);
    }

    @Override
    public void reloadUser(User u, String origin) {
        if (this.config.isUseUUIDs()) {
            this.sendPM(u.getUUID(), "reloadUser;" + u.getUUID(), origin);
        } else {
            this.sendPM(u.getName(), "reloadUser;" + u.getName(), origin);
        }
    }

    @Override
    public void reloadGroup(Group g, String origin) {
        this.sendPMAll("reloadGroup;" + g.getName(), origin);
    }

    @Override
    public void reloadUsers(String origin) {
        this.sendPMAll("reloadUsers", origin);
    }

    @Override
    public void reloadGroups(String origin) {
        this.sendPMAll("reloadGroups", origin);
    }

    @Override
    public void reloadAll(String origin) {
        this.sendPMAll("reloadall", origin);
    }

    public void sendUUIDAndPlayer(String name, UUID uuid) {
        if (this.config.isUseUUIDs()) {
            this.sendPM(uuid, "uuidcheck;" + name + ";" + uuid, null);
        }
    }

    private void sendPM(String player, String msg, String origin) {
        if (this.config.getNetworkType() == NetworkType.Standalone) {
            return;
        }
        ProxiedPlayer pp = ProxyServer.getInstance().getPlayer(player);
        if (pp != null && pp.getServer() != null) {
            if (this.config.getNetworkType() == NetworkType.ServerDependend && !Statics.listContains(this.config.getNetworkServers(), pp.getServer().getInfo().getName())) {
                return;
            }
            if (this.config.getNetworkType() == NetworkType.ServerDependendBlacklist && Statics.listContains(this.config.getNetworkServers(), pp.getServer().getInfo().getName())) {
                return;
            }
            if (origin != null && pp.getServer().getInfo().getName().equalsIgnoreCase(origin)) {
                return;
            }
            pp.getServer().getInfo().sendData("bungeeperms", msg.getBytes());
            this.sendConfig(pp.getServer().getInfo());
        }
    }

    private void sendPM(UUID player, String msg, String origin) {
        if (this.config.getNetworkType() == NetworkType.Standalone) {
            return;
        }
        ProxiedPlayer pp = ProxyServer.getInstance().getPlayer(player);
        if (pp != null && pp.getServer() != null) {
            if (this.config.getNetworkType() == NetworkType.ServerDependend && !Statics.listContains(this.config.getNetworkServers(), pp.getServer().getInfo().getName())) {
                return;
            }
            if (this.config.getNetworkType() == NetworkType.ServerDependendBlacklist && Statics.listContains(this.config.getNetworkServers(), pp.getServer().getInfo().getName())) {
                return;
            }
            if (origin != null && pp.getServer().getInfo().getName().equalsIgnoreCase(origin)) {
                return;
            }
            pp.getServer().getInfo().sendData("bungeeperms", msg.getBytes());
            this.sendConfig(pp.getServer().getInfo());
        }
    }

    private void sendPMAll(String msg, String origin) {
        if (this.config.getNetworkType() == NetworkType.Standalone) {
            return;
        }
        for (ServerInfo si : ProxyServer.getInstance().getConfig().getServers().values()) {
            if (this.config.getNetworkType() == NetworkType.ServerDependend && !Statics.listContains(this.config.getNetworkServers(), si.getName())) {
                return;
            }
            if (this.config.getNetworkType() == NetworkType.ServerDependendBlacklist && Statics.listContains(this.config.getNetworkServers(), si.getName())) {
                return;
            }
            if (origin != null && si.getName().equalsIgnoreCase(origin)) continue;
            si.sendData("bungeeperms", msg.getBytes());
            this.sendConfig(si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfig(ServerInfo info) {
        BungeeNotifier bungeeNotifier = this;
        synchronized (bungeeNotifier) {
            long now = System.currentTimeMillis();
            if (this.lastConfigUpdate + 300000L < now) {
                this.lastConfigUpdate = now;
                info.sendData("bungeeperms", ("configcheck;" + info.getName() + ";" + (Object)((Object)this.config.getBackEndType()) + ";" + (Object)((Object)this.config.getUUIDPlayerDBType()) + ";" + this.config.isUseUUIDs()).getBytes());
            }
        }
    }

    @ConstructorProperties(value={"config"})
    public BungeeNotifier(BungeeConfig config) {
        this.config = config;
    }
}

