/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.beans.ConstructorProperties;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.PermissionsChecker;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.platform.bungee.BungeeConfig;
import net.alpenblock.bungeeperms.platform.bungee.BungeePlugin;
import net.alpenblock.bungeeperms.platform.bungee.BungeeSender;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeePermissionsChecker
extends PermissionsChecker {
    private final BungeeConfig config;

    public boolean hasPerm(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            return (this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName())).hasPerm(permission);
        }
        return false;
    }

    public boolean hasPermOrConsole(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            return (this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName())).hasPerm(permission);
        }
        return new BungeeSender(sender).isConsole();
    }

    public boolean hasPermOnServer(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            User user;
            User user2 = user = this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName());
            if (((ProxiedPlayer)sender).getServer() == null) {
                return user.hasPerm(permission);
            }
            return user.hasPermOnServer(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName());
        }
        return false;
    }

    public boolean hasPermOrConsoleOnServer(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            User user;
            User user2 = user = this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName());
            if (((ProxiedPlayer)sender).getServer() == null) {
                return user.hasPerm(permission);
            }
            return user.hasPermOnServer(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName());
        }
        return new BungeeSender(sender).isConsole();
    }

    public boolean hasPermOnServerInWorld(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            User user;
            User user2 = user = this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName());
            if (((ProxiedPlayer)sender).getServer() == null) {
                return user.hasPerm(permission);
            }
            String world = BungeePlugin.getInstance().getListener().getPlayerWorlds().get(sender.getName());
            if (world == null) {
                return user.hasPermOnServer(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName());
            }
            return user.hasPermOnServerInWorld(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName(), world);
        }
        return false;
    }

    public boolean hasPermOrConsoleOnServerInWorld(CommandSender sender, String permission) {
        if (sender instanceof ProxiedPlayer) {
            User user;
            User user2 = user = this.config.isUseUUIDs() ? this.pm().getUser(((ProxiedPlayer)sender).getUniqueId()) : this.pm().getUser(sender.getName());
            if (((ProxiedPlayer)sender).getServer() == null) {
                return user.hasPerm(permission);
            }
            String world = BungeePlugin.getInstance().getListener().getPlayerWorlds().get(sender.getName());
            if (world == null) {
                return user.hasPermOnServer(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName());
            }
            return user.hasPermOnServerInWorld(permission, ((ProxiedPlayer)sender).getServer().getInfo().getName(), world);
        }
        return new BungeeSender(sender).isConsole();
    }

    public boolean has(CommandSender sender, String perm, boolean msg) {
        if (sender instanceof ProxiedPlayer) {
            boolean isperm = this.hasPerm(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsole(CommandSender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPerm(sender, perm) || new BungeeSender(sender).isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    public boolean hasOnServer(CommandSender sender, String perm, boolean msg) {
        if (sender instanceof ProxiedPlayer) {
            boolean isperm = this.hasPermOnServer(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsoleOnServer(CommandSender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPermOnServer(sender, perm) || new BungeeSender(sender).isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    public boolean hasOnServerInWorld(CommandSender sender, String perm, boolean msg) {
        if (sender instanceof ProxiedPlayer) {
            boolean isperm = this.hasPermOnServerInWorld(sender, perm);
            if (!isperm && msg) {
                sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
            }
            return isperm;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        return false;
    }

    public boolean hasOrConsoleOnServerInWorld(CommandSender sender, String perm, boolean msg) {
        boolean isperm;
        boolean bl = isperm = this.hasPermOnServerInWorld(sender, perm) || new BungeeSender(sender).isConsole();
        if (!isperm && msg) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_PERM, new Object[0]));
        }
        return isperm;
    }

    @ConstructorProperties(value={"config"})
    public BungeePermissionsChecker(BungeeConfig config) {
        this.config = config;
    }
}

