/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Color;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.PlatformType;
import net.alpenblock.bungeeperms.platform.PluginMessageSender;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bungee.BungeeConfig;
import net.alpenblock.bungeeperms.platform.bungee.BungeeEventDispatcher;
import net.alpenblock.bungeeperms.platform.bungee.BungeeEventListener;
import net.alpenblock.bungeeperms.platform.bungee.BungeeMessageEncoder;
import net.alpenblock.bungeeperms.platform.bungee.BungeeNotifier;
import net.alpenblock.bungeeperms.platform.bungee.BungeePluginMessageSender;
import net.alpenblock.bungeeperms.platform.bungee.BungeeSender;
import net.alpenblock.bungeeperms.platform.independend.GroupProcessor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlugin
extends Plugin
implements PlatformPlugin {
    private static BungeePlugin instance;
    private BungeeConfig config;
    private BungeeEventListener listener;
    private BungeeEventDispatcher dispatcher;
    private BungeeNotifier notifier;
    private PluginMessageSender pmsender;
    private BungeePerms bungeeperms;
    private final PlatformType platformType = PlatformType.BungeeCord;

    public void onLoad() {
        instance = this;
        Config conf = new Config(this, "/config.yml");
        conf.load();
        this.config = new BungeeConfig(conf);
        this.config.load();
        this.loadcmds();
        this.listener = new BungeeEventListener(this.config);
        this.dispatcher = new BungeeEventDispatcher();
        this.notifier = new BungeeNotifier(this.config);
        this.pmsender = new BungeePluginMessageSender();
        this.bungeeperms = new BungeePerms(this, this.config, this.pmsender, this.notifier, this.listener, this.dispatcher);
        this.bungeeperms.load();
        this.bungeeperms.getPermissionsResolver().registerProcessor(new GroupProcessor());
    }

    public void onEnable() {
        ProxyServer.getInstance().registerChannel("bungeeperms");
        this.bungeeperms.enable();
    }

    public void onDisable() {
        this.bungeeperms.disable();
        ProxyServer.getInstance().unregisterChannel("bungeeperms");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        return this.bungeeperms.getCommandHandler().onCommand(new BungeeSender(sender), cmd.getName(), label, args);
    }

    private void loadcmds() {
        Command cmd = new Command("bungeeperms", null, new String[]{"bp"}){

            public void execute(final CommandSender sender, final String[] args) {
                final 1 cmd = this;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (!BungeePlugin.this.onCommand(sender, cmd, "", args)) {
                            sender.sendMessage((Object)((Object)Color.Error) + "[BungeePerms] Command not found");
                        }
                    }
                };
                if (BungeePlugin.this.config.isAsyncCommands()) {
                    ProxyServer.getInstance().getScheduler().runAsync((Plugin)instance, r);
                } else {
                    r.run();
                }
            }
        };
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, cmd);
    }

    @Override
    public String getPluginName() {
        return this.getDescription().getName();
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public String getAuthor() {
        return this.getDescription().getAuthor();
    }

    @Override
    public String getPluginFolderPath() {
        return this.getDataFolder().getAbsolutePath();
    }

    @Override
    public File getPluginFolder() {
        return this.getDataFolder();
    }

    @Override
    public Sender getPlayer(String name) {
        ProxiedPlayer sender = ProxyServer.getInstance().getPlayer(name);
        BungeeSender s = null;
        if (sender != null) {
            s = new BungeeSender((CommandSender)sender);
        }
        return s;
    }

    @Override
    public Sender getPlayer(UUID uuid) {
        ProxiedPlayer sender = ProxyServer.getInstance().getPlayer(uuid);
        BungeeSender s = null;
        if (sender != null) {
            s = new BungeeSender((CommandSender)sender);
        }
        return s;
    }

    @Override
    public Sender getConsole() {
        return new BungeeSender(ProxyServer.getInstance().getConsole());
    }

    @Override
    public List<Sender> getPlayers() {
        ArrayList<Sender> senders = new ArrayList<Sender>();
        for (ProxiedPlayer pp : ProxyServer.getInstance().getPlayers()) {
            senders.add(new BungeeSender((CommandSender)pp));
        }
        return senders;
    }

    @Override
    public boolean isChatApiPresent() {
        try {
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public MessageEncoder newMessageEncoder() {
        return new BungeeMessageEncoder("");
    }

    @Override
    public int registerRepeatingTask(Runnable r, long delay, long interval) {
        return ProxyServer.getInstance().getScheduler().schedule((Plugin)this, r, delay, interval, TimeUnit.MILLISECONDS).getId();
    }

    @Override
    public void cancelTask(int id) {
        ProxyServer.getInstance().getScheduler().cancel(id);
    }

    public BungeeConfig getConfig() {
        return this.config;
    }

    public BungeeEventListener getListener() {
        return this.listener;
    }

    public BungeeEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public BungeeNotifier getNotifier() {
        return this.notifier;
    }

    public PluginMessageSender getPmsender() {
        return this.pmsender;
    }

    public BungeePerms getBungeeperms() {
        return this.bungeeperms;
    }

    @Override
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public static BungeePlugin getInstance() {
        return instance;
    }
}

