/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.platform.bungee;

import java.beans.ConstructorProperties;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.platform.bungee.BungeeEventListener;
import net.alpenblock.bungeeperms.platform.bungee.BungeeMessageEncoder;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeSender
implements Sender {
    private CommandSender sender;

    @Override
    public void sendMessage(String message) {
        this.sender.sendMessage(message);
    }

    @Override
    public void sendMessage(MessageEncoder encoder) {
        BungeeMessageEncoder e = (BungeeMessageEncoder)encoder;
        if (BungeePerms.getInstance().getPlugin().isChatApiPresent()) {
            BaseComponent[] converted = BungeeMessageEncoder.convert(e.create());
            this.sender.sendMessage(converted);
        } else {
            this.sender.sendMessage(e.toString());
        }
    }

    @Override
    public String getName() {
        return this.sender.getName();
    }

    @Override
    public UUID getUUID() {
        if (this.isConsole()) {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        if (this.sender instanceof ProxiedPlayer) {
            return ((ProxiedPlayer)this.sender).getUniqueId();
        }
        return null;
    }

    @Override
    public String getServer() {
        if (this.sender instanceof ProxiedPlayer) {
            ProxiedPlayer pp = (ProxiedPlayer)this.sender;
            return pp.getServer() != null ? pp.getServer().getInfo().getName() : null;
        }
        return null;
    }

    @Override
    public String getWorld() {
        BungeeEventListener l = (BungeeEventListener)BungeePerms.getInstance().getEventListener();
        return l.getPlayerWorlds().get(this.sender.getName());
    }

    @Override
    public boolean isConsole() {
        return this.sender.getClass().getName().equals("net.md_5.bungee.command.ConsoleCommandSender");
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof ProxiedPlayer;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    @ConstructorProperties(value={"sender"})
    public BungeeSender(CommandSender sender) {
        this.sender = sender;
    }
}

