/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms.uuid;

import com.google.gson.Gson;
import com.mojang.api.profiles.Profile;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.uuid.HttpProfileRepository;

public class UUIDFetcher {
    private final HttpProfileRepository repo = new HttpProfileRepository();
    private final List<String> tofetch;
    private final Map<String, UUID> UUIDs;
    private final Map<UUID, String> playerNames;
    private final int cooldown;

    public UUIDFetcher(List<String> tofetch, int cooldown) {
        this.tofetch = tofetch;
        this.UUIDs = new HashMap<String, UUID>();
        this.playerNames = new HashMap<UUID, String>();
        this.cooldown = cooldown;
    }

    public void fetchUUIDs() {
        for (String player : this.tofetch) {
            UUID uuid = UUIDFetcher.getUUIDFromMojang(player, this.repo);
            if (uuid != null) {
                this.UUIDs.put(player, uuid);
            }
            Thread.sleep(this.cooldown);
        }
    }

    public void fetchPlayerNames() {
        for (String suuid : this.tofetch) {
            UUID uuid = UUID.fromString(suuid);
            String playername = UUIDFetcher.getPlayerNameFromMojang(uuid);
            if (playername != null) {
                this.playerNames.put(uuid, playername);
            }
            Thread.sleep(this.cooldown);
        }
    }

    public static UUID getUUIDFromMojang(String player, HttpProfileRepository repo) {
        Profile[] profiles;
        if (repo == null) {
            repo = new HttpProfileRepository();
        }
        for (Profile p : profiles = repo.findProfilesOfUsers(new String[]{player})) {
            UUID uuid = Statics.parseUUID(p.getId());
            if (uuid == null) continue;
            return uuid;
        }
        return null;
    }

    public static String getPlayerNameFromMojang(UUID uuid) {
        String suuid = uuid.toString().toLowerCase().replaceAll("-", "");
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + suuid);
            URLConnection con = url.openConnection();
            InputStream in = con.getInputStream();
            byte[] buffer = new byte[con.getContentLength()];
            int read = in.read(buffer);
            String res = new String(buffer, 0, read);
            Gson gson = new Gson();
            PlayerNameFetchResult result = gson.fromJson(res, PlayerNameFetchResult.class);
            return result.getName();
        }
        catch (Exception e) {
            BungeePerms.getInstance().getDebug().log(e);
            return null;
        }
    }

    public List<String> getTofetch() {
        return this.tofetch;
    }

    public Map<String, UUID> getUUIDs() {
        return this.UUIDs;
    }

    public Map<UUID, String> getPlayerNames() {
        return this.playerNames;
    }

    private class PlayerNameFetchResult {
        private String id;
        private String name;

        private PlayerNameFetchResult() {
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

