/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api;

import com.google.common.base.Preconditions;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public abstract class AbstractReconnectHandler
implements ReconnectHandler {
    @Override
    public ServerInfo getServer(ProxiedPlayer player) {
        ServerInfo server = AbstractReconnectHandler.getForcedHost(player.getPendingConnection());
        if (server == null) {
            server = this.getStoredServer(player);
            if (server == null) {
                server = ProxyServer.getInstance().getServerInfo(player.getPendingConnection().getListener().getDefaultServer());
            }
            Preconditions.checkState((server != null ? 1 : 0) != 0, (Object)"Default server not defined");
        }
        return server;
    }

    public static ServerInfo getForcedHost(PendingConnection con) {
        if (con.getVirtualHost() == null) {
            return null;
        }
        String forced = con.getListener().getForcedHosts().get(con.getVirtualHost().getHostString());
        if (forced == null && con.getListener().isForceDefault()) {
            forced = con.getListener().getDefaultServer();
        }
        return ProxyServer.getInstance().getServerInfo(forced);
    }

    protected abstract ServerInfo getStoredServer(ProxiedPlayer var1);
}

