/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.md_5.bungee.jni.cipher.BungeeCipher;

public final class NativeCode<T> {
    private final String name;
    private final Class<T> javaImpl;
    private final Class<T> nativeImpl;
    private boolean loaded;

    public NativeCode(String name, Class<T> javaImpl, Class<T> nativeImpl) {
        this.name = name;
        this.javaImpl = javaImpl;
        this.nativeImpl = nativeImpl;
    }

    public T newInstance() {
        try {
            return this.loaded ? this.nativeImpl.newInstance() : this.javaImpl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Error getting instance", ex);
        }
    }

    public boolean load() {
        if (!this.loaded && NativeCode.isSupported()) {
            String fullName = "bungeecord-" + this.name;
            try {
                System.loadLibrary(fullName);
                this.loaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.loaded) {
                try (InputStream soFile2 = BungeeCipher.class.getClassLoader().getResourceAsStream(this.name + ".so");){
                    File temp = File.createTempFile(fullName, ".so");
                    temp.deleteOnExit();
                    try (FileOutputStream outputStream = new FileOutputStream(temp);){
                        ByteStreams.copy((InputStream)soFile2, (OutputStream)outputStream);
                    }
                    System.load(temp.getPath());
                    this.loaded = true;
                }
                catch (IOException soFile2) {
                }
                catch (UnsatisfiedLinkError ex) {
                    System.out.println("Could not load native library: " + ex.getMessage());
                }
            }
        }
        return this.loaded;
    }

    public static boolean isSupported() {
        return "Linux".equals(System.getProperty("os.name")) && "amd64".equals(System.getProperty("os.arch"));
    }
}

