/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private final BungeeZlib zlib = (BungeeZlib)CompressFactory.zlib.newInstance();
    private int threshold = 256;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.zlib.init(true, -1);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.zlib.free();
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int origSize = msg.readableBytes();
        if (origSize < this.threshold) {
            DefinedPacket.writeVarInt((int)0, (ByteBuf)out);
            out.writeBytes(msg);
        } else {
            DefinedPacket.writeVarInt((int)origSize, (ByteBuf)out);
            this.zlib.process(msg, out);
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

