/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.forge;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.md_5.bungee.forge.ForgeConstants;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ForgeUtils {
    public static Set<String> readRegisteredChannels(PluginMessage pluginMessage) {
        String channels = new String(pluginMessage.getData(), Charsets.UTF_8);
        Object[] split = channels.split("\u0000");
        ImmutableSet channelSet = ImmutableSet.copyOf((Object[])split);
        return channelSet;
    }

    public static Map<String, String> readModList(PluginMessage pluginMessage) {
        HashMap modTags = Maps.newHashMap();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])pluginMessage.getData());
        byte discriminator = payload.readByte();
        if (discriminator == 2) {
            ByteBuf buffer = payload.slice();
            int modCount = DefinedPacket.readVarInt((ByteBuf)buffer, (int)2);
            for (int i = 0; i < modCount; ++i) {
                modTags.put(DefinedPacket.readString((ByteBuf)buffer), DefinedPacket.readString((ByteBuf)buffer));
            }
        }
        return modTags;
    }

    public static int getFmlBuildNumber(Map<String, String> modList) {
        if (modList.containsKey("FML")) {
            String fmlVersion = modList.get("FML");
            if (fmlVersion.equals("7.10.99.99")) {
                Matcher matcher = ForgeConstants.FML_HANDSHAKE_VERSION_REGEX.matcher(modList.get("Forge"));
                if (matcher.find()) {
                    return Integer.parseInt(matcher.group(4));
                }
            } else {
                Matcher matcher = ForgeConstants.FML_HANDSHAKE_VERSION_REGEX.matcher(fmlVersion);
                if (matcher.find()) {
                    return Integer.parseInt(matcher.group(4));
                }
            }
        }
        return 0;
    }
}

