/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class ChannelWrapper {
    private final Channel ch;
    private volatile boolean closed;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
    }

    public void setProtocol(Protocol protocol) {
        ((MinecraftDecoder)this.ch.pipeline().get(MinecraftDecoder.class)).setProtocol(protocol);
        ((MinecraftEncoder)this.ch.pipeline().get(MinecraftEncoder.class)).setProtocol(protocol);
    }

    public void setVersion(int protocol) {
        ((MinecraftDecoder)this.ch.pipeline().get(MinecraftDecoder.class)).setProtocolVersion(protocol);
        ((MinecraftEncoder)this.ch.pipeline().get(MinecraftEncoder.class)).setProtocolVersion(protocol);
    }

    public void write(Object packet) {
        if (!this.closed) {
            if (packet instanceof PacketWrapper) {
                ((PacketWrapper)packet).setReleased(true);
                this.ch.write((Object)((PacketWrapper)packet).buf, this.ch.voidPromise());
            } else {
                this.ch.write(packet, this.ch.voidPromise());
            }
            this.ch.flush();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.ch.flush();
            this.ch.close();
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState((boolean)this.ch.eventLoop().inEventLoop(), (Object)"cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (this.ch.pipeline().get(PacketCompressor.class) == null && compressionThreshold != -1) {
            this.addBefore("packet-encoder", "compress", (ChannelHandler)new PacketCompressor());
        }
        if (compressionThreshold != -1) {
            ((PacketCompressor)this.ch.pipeline().get(PacketCompressor.class)).setThreshold(compressionThreshold);
        } else {
            this.ch.pipeline().remove("compress");
        }
        if (this.ch.pipeline().get(PacketDecompressor.class) == null && compressionThreshold != -1) {
            this.addBefore("packet-decoder", "decompress", (ChannelHandler)new PacketDecompressor());
        }
        if (compressionThreshold == -1) {
            this.ch.pipeline().remove("decompress");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

