/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints;

import com.evilmidget38.UUIDFetcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.black_ixx.playerpoints.PlayerPointsVaultLayer;
import org.black_ixx.playerpoints.commands.Commander;
import org.black_ixx.playerpoints.config.LocalizeConfig;
import org.black_ixx.playerpoints.config.RootConfig;
import org.black_ixx.playerpoints.listeners.RestrictionListener;
import org.black_ixx.playerpoints.listeners.VotifierListener;
import org.black_ixx.playerpoints.services.IModule;
import org.black_ixx.playerpoints.storage.StorageHandler;
import org.black_ixx.playerpoints.storage.exports.Exporter;
import org.black_ixx.playerpoints.storage.imports.Importer;
import org.black_ixx.playerpoints.update.UpdateManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerPoints
extends JavaPlugin {
    public static final String TAG = "[PlayerPoints]";
    private PlayerPointsAPI api;
    private final Map<Class<? extends IModule>, IModule> modules = new HashMap<Class<? extends IModule>, IModule>();

    public void onEnable() {
        LocalizeConfig.init(this);
        RootConfig rootConfig = new RootConfig(this);
        this.registerModule(RootConfig.class, rootConfig);
        Importer importer = new Importer(this);
        importer.checkImport();
        Exporter exporter = new Exporter(this);
        exporter.checkExport();
        this.registerModule(StorageHandler.class, new StorageHandler(this));
        this.api = new PlayerPointsAPI(this);
        UpdateManager update = new UpdateManager(this);
        update.checkUpdate();
        Commander commander = new Commander(this);
        if (this.getDescription().getCommands().containsKey("points")) {
            this.getCommand("points").setExecutor((CommandExecutor)commander);
        }
        if (this.getDescription().getCommands().containsKey("p")) {
            this.getCommand("p").setExecutor((CommandExecutor)commander);
        }
        PluginManager pm = this.getServer().getPluginManager();
        if (rootConfig.voteEnabled) {
            Plugin votifier = pm.getPlugin("Votifier");
            if (votifier != null) {
                pm.registerEvents((Listener)new VotifierListener(this), (Plugin)this);
            } else {
                this.getLogger().warning("Could not hook into Votifier!");
            }
        }
        if (rootConfig.vault) {
            this.registerModule(PlayerPointsVaultLayer.class, new PlayerPointsVaultLayer(this));
        }
        pm.registerEvents((Listener)new RestrictionListener(this), (Plugin)this);
    }

    public void onDisable() {
        ArrayList<Class<? extends IModule>> clazzez = new ArrayList<Class<? extends IModule>>();
        clazzez.addAll(this.modules.keySet());
        for (Class clazz : clazzez) {
            this.deregisterModuleForClass(clazz);
        }
    }

    public PlayerPointsAPI getAPI() {
        return this.api;
    }

    public <T extends IModule> void registerModule(Class<T> clazz, T module) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        if (this.modules.containsKey(clazz)) {
            this.getLogger().warning("Overwriting module for class: " + clazz.getName());
        }
        this.modules.put(clazz, module);
        module.starting();
    }

    public <T extends IModule> T deregisterModuleForClass(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        IModule module = (IModule)clazz.cast(this.modules.get(clazz));
        if (module != null) {
            module.closing();
        }
        return (T)module;
    }

    public <T extends IModule> T getModuleForClass(Class<T> clazz) {
        return (T)((IModule)clazz.cast(this.modules.get(clazz)));
    }

    public String expandName(String name) {
        Player[] online;
        int m = 0;
        String Result = "";
        for (Player player : online = this.getServer().getOnlinePlayers()) {
            String str = player.getName();
            if (str.matches("(?i).*" + name + ".*")) {
                Result = str;
                if (++m == 2) {
                    return null;
                }
            }
            if (!str.equalsIgnoreCase(name)) continue;
            return str;
        }
        if (m == 1) {
            return Result;
        }
        if (m > 1) {
            return null;
        }
        return name;
    }

    public UUID translateNameToUUID(String name) {
        UUID id = null;
        RootConfig config = this.getModuleForClass(RootConfig.class);
        if (config.debugUUID) {
            this.getLogger().info("translateNameToUUID(" + name + ")");
        }
        if (name == null) {
            if (config.debugUUID) {
                this.getLogger().info("translateNameToUUID() - bad ID");
            }
            return id;
        }
        if (config.debugUUID) {
            this.getLogger().info("translateNameToUUID() - Looking through online players: " + Bukkit.getServer().getOnlinePlayers().length);
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            id = p.getUniqueId();
            if (!config.debugUUID) break;
            this.getLogger().info("translateNameToUUID() online player UUID found: " + id.toString());
            break;
        }
        if (id == null && Bukkit.getServer().getOnlineMode()) {
            if (config.debugUUID) {
                this.getLogger().info("translateNameToUUID() - Attempting online lookup");
            }
            UUIDFetcher fetcher = new UUIDFetcher(Arrays.asList(name));
            try {
                Object map = fetcher.call();
                for (Map.Entry entry : map.entrySet()) {
                    if (!name.equalsIgnoreCase((String)entry.getKey())) continue;
                    id = (UUID)entry.getValue();
                    if (config.debugUUID) {
                        this.getLogger().info("translateNameToUUID() web player UUID found: " + (id == null ? id : id.toString()));
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Exception on online UUID fetch", e);
            }
        } else if (id == null && !Bukkit.getServer().getOnlineMode()) {
            id = Bukkit.getServer().getOfflinePlayer(name).getUniqueId();
            if (config.debugUUID) {
                this.getLogger().info("translateNameToUUID() offline player UUID found: " + (id == null ? id : id.toString()));
            }
        }
        return id;
    }
}

