/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints;

import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.event.PlayerPointsChangeEvent;
import org.black_ixx.playerpoints.event.PlayerPointsResetEvent;
import org.black_ixx.playerpoints.storage.StorageHandler;
import org.bukkit.event.Event;

public class PlayerPointsAPI {
    private final PlayerPoints plugin;

    public PlayerPointsAPI(PlayerPoints p) {
        this.plugin = p;
    }

    public boolean give(UUID playerId, int amount) {
        if (playerId == null) {
            return false;
        }
        PlayerPointsChangeEvent event = new PlayerPointsChangeEvent(playerId, amount);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            int total = this.look(playerId) + event.getChange();
            return this.plugin.getModuleForClass(StorageHandler.class).setPoints(playerId.toString(), total);
        }
        return false;
    }

    @Deprecated
    public boolean give(String playerName, int amount) {
        boolean success = false;
        if (playerName != null) {
            success = this.give(this.plugin.translateNameToUUID(playerName), amount);
        }
        return success;
    }

    public boolean take(UUID playerId, int amount) {
        int points = this.look(playerId);
        int take = amount;
        if (take > 0) {
            take *= -1;
        }
        if (points + take < 0) {
            return false;
        }
        return this.give(playerId, take);
    }

    @Deprecated
    public boolean take(String playerName, int amount) {
        boolean success = false;
        if (playerName != null) {
            success = this.take(this.plugin.translateNameToUUID(playerName), amount);
        }
        return success;
    }

    public int look(UUID playerId) {
        int amount = 0;
        if (playerId != null) {
            amount = this.plugin.getModuleForClass(StorageHandler.class).getPoints(playerId.toString());
        }
        return amount;
    }

    @Deprecated
    public int look(String playerName) {
        return this.look(this.plugin.translateNameToUUID(playerName));
    }

    public boolean pay(UUID source, UUID target, int amount) {
        if (this.take(source, amount)) {
            if (this.give(target, amount)) {
                return true;
            }
            this.give(source, amount);
        }
        return false;
    }

    @Deprecated
    public boolean pay(String sourceName, String targetName, int amount) {
        boolean success = false;
        if (sourceName != null && targetName != null) {
            success = this.pay(this.plugin.translateNameToUUID(sourceName), this.plugin.translateNameToUUID(targetName), amount);
        }
        return success;
    }

    public boolean set(UUID playerId, int amount) {
        if (playerId == null) {
            return false;
        }
        PlayerPointsChangeEvent event = new PlayerPointsChangeEvent(playerId, amount - this.look(playerId));
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return this.plugin.getModuleForClass(StorageHandler.class).setPoints(playerId.toString(), this.look(playerId) + event.getChange());
        }
        return false;
    }

    @Deprecated
    public boolean set(String playerName, int amount) {
        boolean success = false;
        if (playerName != null) {
            success = this.set(this.plugin.translateNameToUUID(playerName), amount);
        }
        return success;
    }

    public boolean reset(UUID playerId) {
        if (playerId == null) {
            return false;
        }
        PlayerPointsResetEvent event = new PlayerPointsResetEvent(playerId);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return this.plugin.getModuleForClass(StorageHandler.class).setPoints(playerId.toString(), event.getChange());
        }
        return false;
    }

    @Deprecated
    public boolean reset(String playerName, int amount) {
        boolean success = false;
        if (playerName != null) {
            success = this.reset(this.plugin.translateNameToUUID(playerName));
        }
        return success;
    }
}

