/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.services.IModule;
import org.black_ixx.playerpoints.storage.StorageHandler;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class PlayerPointsVaultLayer
implements Economy,
IModule {
    private PlayerPoints plugin;

    public PlayerPointsVaultLayer(PlayerPoints plugin) {
        this.plugin = plugin;
    }

    @Override
    public void starting() {
        this.plugin.getServer().getServicesManager().register(Economy.class, (Object)this, (Plugin)this.plugin, ServicePriority.Low);
    }

    @Override
    public void closing() {
        this.plugin.getServer().getServicesManager().unregister(Economy.class, (Object)this);
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String getName() {
        return this.plugin.getName();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        StringBuilder sb = new StringBuilder();
        int points = (int)amount;
        sb.append(points + " ");
        if (points == 1) {
            sb.append(this.currencyNameSingular());
        } else {
            sb.append(this.currencyNamePlural());
        }
        return sb.toString();
    }

    public String currencyNamePlural() {
        return "Points";
    }

    public String currencyNameSingular() {
        return "Point";
    }

    public boolean hasAccount(String playerName) {
        boolean has = false;
        UUID id = this.handleTranslation(playerName);
        if (id != null) {
            has = this.plugin.getModuleForClass(StorageHandler.class).playerEntryExists(id.toString());
        }
        return has;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public double getBalance(String playerName) {
        return this.plugin.getAPI().look(this.handleTranslation(playerName));
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public boolean has(String playerName, double amount) {
        int current = this.plugin.getAPI().look(this.handleTranslation(playerName));
        return (double)current >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        int points = (int)amount;
        boolean result = this.plugin.getAPI().take(this.handleTranslation(playerName), points);
        int balance = this.plugin.getAPI().look(this.handleTranslation(playerName));
        EconomyResponse response = null;
        response = result ? new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.SUCCESS, null) : new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.FAILURE, "Lack funds");
        return response;
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        int points = (int)amount;
        boolean result = this.plugin.getAPI().give(this.handleTranslation(playerName), points);
        int balance = this.plugin.getAPI().look(this.handleTranslation(playerName));
        EconomyResponse response = null;
        response = result ? new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.SUCCESS, null) : new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.FAILURE, null);
        return response;
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String playerName) {
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    private UUID handleTranslation(String name) {
        UUID id = null;
        try {
            UUID.fromString(name);
        }
        catch (IllegalArgumentException e) {
            id = this.plugin.translateNameToUUID(name);
        }
        return id;
    }

    public EconomyResponse createBank(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String world) {
        return true;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        int points = (int)amount;
        boolean result = this.plugin.getAPI().give(player.getUniqueId(), points);
        int balance = this.plugin.getAPI().look(player.getUniqueId());
        EconomyResponse response = null;
        response = result ? new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.SUCCESS, null) : new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.FAILURE, null);
        return response;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        return this.depositPlayer(player, amount);
    }

    public double getBalance(OfflinePlayer player) {
        return this.plugin.getAPI().look(player.getUniqueId());
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount) {
        int current = this.plugin.getAPI().look(player.getUniqueId());
        return (double)current >= amount;
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        return this.has(player, amount);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.plugin.getModuleForClass(StorageHandler.class).playerEntryExists(player.getUniqueId().toString());
    }

    public boolean hasAccount(OfflinePlayer player, String world) {
        return this.hasAccount(player);
    }

    public EconomyResponse isBankMember(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse isBankOwner(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Does not handle banks.");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        int points = (int)amount;
        boolean result = this.plugin.getAPI().take(player.getUniqueId(), points);
        int balance = this.plugin.getAPI().look(player.getUniqueId());
        EconomyResponse response = null;
        response = result ? new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.SUCCESS, null) : new EconomyResponse(amount, (double)balance, EconomyResponse.ResponseType.FAILURE, "Lack funds");
        return response;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        return this.withdrawPlayer(player, amount);
    }
}

