/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.commands;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.LocalizeConfig;
import org.black_ixx.playerpoints.config.LocalizeNode;
import org.black_ixx.playerpoints.models.Flag;
import org.black_ixx.playerpoints.models.SortedPlayer;
import org.black_ixx.playerpoints.permissions.PermissionHandler;
import org.black_ixx.playerpoints.permissions.PermissionNode;
import org.black_ixx.playerpoints.services.CommandHandler;
import org.black_ixx.playerpoints.storage.StorageHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class LeadCommand
extends CommandHandler {
    private static final int LIMIT = 10;
    private final Map<String, Integer> page = new HashMap<String, Integer>();

    public LeadCommand(PlayerPoints plugin) {
        super(plugin, "lead");
    }

    @Override
    public boolean noArgs(CommandSender sender, Command command, String label, EnumMap<Flag, String> info) {
        if (!PermissionHandler.has(sender, PermissionNode.LEAD)) {
            info.put(Flag.EXTRA, PermissionNode.LEAD.getNode());
            sender.sendMessage(LocalizeConfig.parseString(LocalizeNode.PERMISSION_DENY, info));
            return true;
        }
        SortedSet<SortedPlayer> leaders = this.sortLeaders(this.plugin, this.plugin.getModuleForClass(StorageHandler.class).getPlayers());
        int current = 0;
        if (this.page.containsKey(sender.getName())) {
            current = this.page.get(sender.getName());
        }
        int num = leaders.size() / 10;
        double rem = (double)leaders.size() % 10.0;
        if (rem != 0.0) {
            ++num;
        }
        if (current < 0) {
            current = 0;
            this.page.put(sender.getName(), current);
        } else if (current >= num) {
            current = num - 1;
            this.page.put(sender.getName(), current);
        }
        SortedPlayer[] array = leaders.toArray(new SortedPlayer[0]);
        if (leaders.isEmpty()) {
            current = 0;
            num = 0;
        }
        sender.sendMessage(ChatColor.BLUE + "=== " + ChatColor.GRAY + "[PlayerPoints]" + " Leader Board " + ChatColor.BLUE + "=== " + ChatColor.GRAY + (current + 1) + ":" + num);
        for (int i = current * 10; i < current * 10 + 10 && i < array.length; ++i) {
            SortedPlayer player = array[i];
            sender.sendMessage(ChatColor.AQUA + "" + (i + 1) + ". " + ChatColor.GRAY + Bukkit.getOfflinePlayer((UUID)UUID.fromString(player.getName())).getName() + ChatColor.WHITE + " - " + ChatColor.GOLD + player.getPoints());
        }
        return true;
    }

    @Override
    public boolean unknownCommand(CommandSender sender, Command command, String label, String[] args, EnumMap<Flag, String> info) {
        String com = args[0];
        int current = 0;
        if (this.page.containsKey(sender.getName())) {
            current = this.page.get(sender.getName());
        }
        boolean valid = false;
        if (com.equalsIgnoreCase("prev")) {
            this.page.put(sender.getName(), --current);
            this.noArgs(sender, command, label, info);
            valid = true;
        } else if (com.equals("next")) {
            this.page.put(sender.getName(), ++current);
            this.noArgs(sender, command, label, info);
            valid = true;
        } else {
            try {
                current = Integer.parseInt(com);
                this.page.put(sender.getName(), current - 1);
                this.noArgs(sender, command, label, info);
                valid = true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!valid) {
            info.put(Flag.EXTRA, args[0]);
            sender.sendMessage(LocalizeConfig.parseString(LocalizeNode.COMMAND_LEAD, info));
        }
        return true;
    }

    private SortedSet<SortedPlayer> sortLeaders(PlayerPoints plugin, Collection<String> players) {
        TreeSet<SortedPlayer> sorted = new TreeSet<SortedPlayer>();
        for (String name : players) {
            int points = plugin.getAPI().look(UUID.fromString(name));
            sorted.add(new SortedPlayer(name, points));
        }
        return sorted;
    }
}

