/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.LocalizeNode;
import org.black_ixx.playerpoints.models.Flag;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LocalizeConfig {
    private static PlayerPoints plugin;
    private static File file;
    private static YamlConfiguration config;
    private static final EnumMap<LocalizeNode, String> MESSAGES;

    public static void init(PlayerPoints pp) {
        plugin = pp;
        file = new File(plugin.getDataFolder().getAbsolutePath() + "/localization.yml");
        config = YamlConfiguration.loadConfiguration((File)file);
        LocalizeConfig.loadDefaults();
        LocalizeConfig.loadMessages();
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e1) {
            plugin.getLogger().warning("File I/O Exception on saving localization config");
            e1.printStackTrace();
        }
    }

    public static void reload() {
        try {
            config.load(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        MESSAGES.clear();
        LocalizeConfig.loadDefaults();
        LocalizeConfig.loadMessages();
    }

    public static void set(String path, Object o) {
        config.set(path, o);
        LocalizeConfig.save();
    }

    public static String getString(String path, String def) {
        return config.getString(path, def);
    }

    private static void loadDefaults() {
        for (LocalizeNode node : LocalizeNode.values()) {
            if (config.contains(node.getPath())) continue;
            config.set(node.getPath(), (Object)node.getDefaultValue());
        }
        LocalizeConfig.save();
    }

    private static void loadMessages() {
        for (LocalizeNode node : LocalizeNode.values()) {
            MESSAGES.put(node, config.getString(node.getPath(), node.getDefaultValue()));
        }
    }

    public static String parseString(LocalizeNode node, EnumMap<Flag, String> replace) {
        String out = ChatColor.translateAlternateColorCodes((char)'&', (String)MESSAGES.get((Object)node));
        if (replace != null) {
            for (Map.Entry<Flag, String> entry : replace.entrySet()) {
                out = out.replaceAll(entry.getKey().getFlag(), entry.getValue());
            }
        }
        return out;
    }

    static {
        MESSAGES = new EnumMap(LocalizeNode.class);
    }
}

