/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.services.IModule;
import org.black_ixx.playerpoints.storage.StorageType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class RootConfig
implements IModule {
    private PlayerPoints plugin;
    public String host;
    public String port;
    public String database;
    public String user;
    public String password;
    public int voteAmount;
    public int retryLimit;
    public boolean importSQL;
    public boolean exportSQL;
    public boolean voteOnline;
    public boolean voteEnabled;
    public boolean vault;
    public boolean hasPlayedBefore;
    public boolean autocompleteOnline;
    public boolean debugDatabase;
    public boolean debugUUID;
    public StorageType backend;
    public StorageType importSource;
    public StorageType exportSource;

    public RootConfig(PlayerPoints plugin) {
        this.plugin = plugin;
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.loadSettings((ConfigurationSection)config);
    }

    private void loadSettings(ConfigurationSection config) {
        this.debugDatabase = config.getBoolean("debug.database", false);
        this.debugUUID = config.getBoolean("debug.uuid", false);
        this.voteEnabled = config.getBoolean("vote.enabled", false);
        this.voteAmount = config.getInt("vote.amount", 100);
        this.voteOnline = config.getBoolean("vote.online", false);
        this.vault = config.getBoolean("vault", false);
        this.hasPlayedBefore = config.getBoolean("restrictions.hasPlayedBefore", false);
        this.autocompleteOnline = config.getBoolean("restrictions.autocompleteOnline", false);
    }

    private void loadStorageSettings(ConfigurationSection config) {
        String back = config.getString("storage");
        this.backend = back.equalsIgnoreCase("sqlite") ? StorageType.SQLITE : (back.equalsIgnoreCase("mysql") ? StorageType.MYSQL : StorageType.YAML);
        this.host = config.getString("mysql.host", "localhost");
        this.port = config.getString("mysql.port", "3306");
        this.database = config.getString("mysql.database", "minecraft");
        this.user = config.getString("mysql.user", "user");
        this.password = config.getString("mysql.password", "password");
        this.importSQL = config.getBoolean("mysql.import.use", false);
        this.retryLimit = config.getInt("mysql.retry", 10);
        this.exportSQL = config.getBoolean("mysql.export.use", false);
        String databaseImportSource = config.getString("mysql.import.source", "YAML");
        this.importSource = databaseImportSource.equalsIgnoreCase("SQLITE") ? StorageType.SQLITE : StorageType.YAML;
        String databaseExportSource = config.getString("mysql.export.source", "MYSQL");
        this.exportSource = databaseExportSource.equalsIgnoreCase("SQLITE") ? StorageType.SQLITE : StorageType.MYSQL;
    }

    public StorageType getStorageType() {
        return this.backend;
    }

    @Override
    public void starting() {
        FileConfiguration config = this.plugin.getConfig();
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        defaults.put("storage", "YAML");
        defaults.put("mysql.host", "localhost");
        defaults.put("mysql.port", 3306);
        defaults.put("mysql.database", "minecraft");
        defaults.put("mysql.user", "username");
        defaults.put("mysql.password", "pass");
        defaults.put("mysql.import.use", false);
        defaults.put("mysql.import.source", "YAML");
        defaults.put("mysql.export.use", false);
        defaults.put("mysql.export.source", "SQLITE");
        defaults.put("mysql.retry", 10);
        defaults.put("vote.enabled", false);
        defaults.put("vote.amount", 100);
        defaults.put("vote.online", false);
        defaults.put("restrictions.autocompleteOnline", false);
        defaults.put("restrictions.hasPlayedBefore", false);
        defaults.put("debug.database", false);
        defaults.put("debug.uuid", false);
        defaults.put("vault", false);
        defaults.put("version", this.plugin.getDescription().getVersion());
        for (Map.Entry e : defaults.entrySet()) {
            if (config.contains((String)e.getKey())) continue;
            config.set((String)e.getKey(), e.getValue());
        }
        this.plugin.saveConfig();
        this.loadSettings((ConfigurationSection)config);
        this.loadStorageSettings((ConfigurationSection)config);
    }

    @Override
    public void closing() {
    }
}

