/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.services;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.models.Flag;
import org.black_ixx.playerpoints.services.PointsCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public abstract class CommandHandler
implements CommandExecutor {
    protected final Map<String, PointsCommand> registeredCommands = new HashMap<String, PointsCommand>();
    protected final Map<String, CommandHandler> registeredHandlers = new HashMap<String, CommandHandler>();
    protected PlayerPoints plugin;
    protected String cmd;

    public CommandHandler(PlayerPoints plugin, String cmd) {
        this.plugin = plugin;
        this.cmd = cmd;
    }

    public void registerCommand(String label, PointsCommand command) {
        if (this.registeredCommands.containsKey(label)) {
            this.plugin.getLogger().warning("Replacing existing command for: " + label);
        }
        this.registeredCommands.put(label, command);
    }

    public void unregisterCommand(String label) {
        this.registeredCommands.remove(label);
    }

    public void registerHandler(CommandHandler handler) {
        if (this.registeredHandlers.containsKey(handler.getCommand())) {
            this.plugin.getLogger().warning("Replacing existing handler for: " + handler.getCommand());
        }
        this.registeredHandlers.put(handler.getCommand(), handler);
    }

    public void unregisterHandler(String label) {
        this.registeredHandlers.remove(label);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        EnumMap<Flag, String> info = new EnumMap<Flag, String>(Flag.class);
        info.put(Flag.TAG, "[PlayerPoints]");
        if (args.length == 0) {
            return this.noArgs(sender, command, label, info);
        }
        String subcmd = args[0].toLowerCase();
        CommandHandler handler = this.registeredHandlers.get(subcmd);
        if (handler != null) {
            return handler.onCommand(sender, command, label, this.shortenArgs(args));
        }
        PointsCommand subCommand = this.registeredCommands.get(subcmd);
        if (subCommand == null) {
            return this.unknownCommand(sender, command, label, args, info);
        }
        boolean value = true;
        try {
            value = subCommand.execute(this.plugin, sender, command, label, this.shortenArgs(args), info);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage(ChatColor.GRAY + "[PlayerPoints]" + ChatColor.RED + " Missing parameters.");
        }
        return value;
    }

    public abstract boolean noArgs(CommandSender var1, Command var2, String var3, EnumMap<Flag, String> var4);

    public abstract boolean unknownCommand(CommandSender var1, Command var2, String var3, String[] var4, EnumMap<Flag, String> var5);

    protected String[] shortenArgs(String[] args) {
        if (args.length == 0) {
            return args;
        }
        ArrayList<String> argList = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            argList.add(args[i]);
        }
        return argList.toArray(new String[0]);
    }

    public String getCommand() {
        return this.cmd;
    }
}

