/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.services.version;

import java.util.ArrayList;
import java.util.List;

public class PreReleaseType
implements Comparable<PreReleaseType> {
    public static final PreReleaseType NONE = new PreReleaseType("");
    private final String type;
    private String base;
    private final List<String> identifiers = new ArrayList<String>();

    public PreReleaseType(String in) {
        this.type = in;
        try {
            this.base = in.substring(0, in.indexOf("."));
        }
        catch (IndexOutOfBoundsException e) {
            this.base = in;
        }
        String[] ids = in.split("\\.");
        for (int i = 1; i < ids.length; ++i) {
            this.identifiers.add(ids[i]);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getBase() {
        return this.base;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public String toString() {
        return this.type;
    }

    @Override
    public int compareTo(PreReleaseType o) {
        if (this.type.isEmpty() && !o.getType().isEmpty()) {
            return -1;
        }
        int compare = o.getType().toLowerCase().compareTo(this.type.toLowerCase());
        if (compare == 0) {
            int max = Math.max(this.identifiers.size(), o.getIdentifiers().size());
            for (int i = 0; i < max; ++i) {
                String ours = "";
                try {
                    ours = this.identifiers.get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    compare = 1;
                    break;
                }
                String theirs = "";
                try {
                    theirs = o.getIdentifiers().get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    compare = -1;
                    break;
                }
                if (theirs.compareTo(ours) == 0) continue;
                compare = theirs.compareTo(ours);
                break;
            }
        }
        return compare;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PreReleaseType) {
            return this.type.equals(((PreReleaseType)obj).getType());
        }
        return false;
    }
}

