/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.services.version;

import org.apache.commons.lang.StringUtils;
import org.black_ixx.playerpoints.services.version.Metadata;
import org.black_ixx.playerpoints.services.version.PreReleaseType;

public class Version
implements Comparable<Version> {
    private final String version;
    private static final String SEPARATOR = ".";
    private boolean ignorePatch = false;

    public Version(String version) {
        this.version = version.replaceAll("\\s", "");
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.parseNumber(this.version.substring(0, this.version.indexOf(SEPARATOR)));
    }

    public int getMinor() {
        int first = this.version.indexOf(SEPARATOR);
        int second = this.version.indexOf(SEPARATOR, first + 1);
        if (this.ignorePatch) {
            second = this.version.length();
            if (this.getLastSeparatorIndex() > 0) {
                second = this.getLastSeparatorIndex();
            }
        }
        return this.parseNumber(this.version.substring(first + 1, second));
    }

    public int getPatch() {
        if (this.ignorePatch) {
            return 0;
        }
        int first = this.version.indexOf(SEPARATOR, this.version.indexOf(SEPARATOR) + 1) + 1;
        int second = this.version.length();
        if (this.getLastSeparatorIndex() > 0) {
            second = this.getLastSeparatorIndex();
        }
        return this.parseNumber(this.version.substring(first, second));
    }

    private int getLastSeparatorIndex() {
        int last = -1;
        PreReleaseType type = this.getType();
        if (!type.equals(PreReleaseType.NONE)) {
            last = this.version.indexOf("-");
        } else {
            Metadata meta = this.getMetadata();
            if (!meta.equals(Metadata.NONE)) {
                last = this.version.indexOf("+");
            }
        }
        return last;
    }

    public PreReleaseType getType() {
        int first = this.version.indexOf("-");
        int second = this.version.length();
        if (this.version.contains("+")) {
            second = this.version.indexOf("+");
        }
        if (first >= 0) {
            try {
                return new PreReleaseType(this.version.substring(first + 1, second));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return PreReleaseType.NONE;
    }

    public Metadata getMetadata() {
        int first = this.version.indexOf("+");
        if (first >= 0) {
            try {
                return new Metadata(this.version.substring(first + 1, this.version.length()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return Metadata.NONE;
    }

    public boolean isIgnorePatch() {
        return this.ignorePatch;
    }

    public void setIgnorePatch(boolean ignorePatch) {
        this.ignorePatch = ignorePatch;
    }

    public boolean validate() {
        boolean valid = false;
        try {
            this.getMajor();
            this.getMinor();
            this.getPatch();
            valid = this.ignorePatch ? StringUtils.countMatches((String)this.version, (String)SEPARATOR) >= 1 : StringUtils.countMatches((String)this.version, (String)SEPARATOR) >= 2;
            valid = valid && StringUtils.countMatches((String)this.version, (String)"-") <= 1;
            valid = valid && StringUtils.countMatches((String)this.version, (String)"+") <= 1;
        }
        catch (IndexOutOfBoundsException e) {
            valid = false;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    private int parseNumber(String in) {
        int number = Integer.parseInt(in);
        if (number < 0) {
            throw new NumberFormatException("No negative numbers in a version string.");
        }
        return number;
    }

    @Override
    public int compareTo(Version o) {
        if (this.getMajor() != o.getMajor()) {
            return this.getMajor() - o.getMajor();
        }
        if (this.getMinor() != o.getMinor()) {
            return this.getMinor() - o.getMinor();
        }
        if (this.getPatch() != o.getPatch()) {
            return this.getPatch() - o.getPatch();
        }
        if (this.getType() != o.getType()) {
            return o.getType().compareTo(this.getType());
        }
        return 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.version.equals(((Version)obj).getVersion());
        }
        return false;
    }

    public String toString() {
        return this.version;
    }
}

