/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.RootConfig;
import org.black_ixx.playerpoints.storage.IStorage;

public abstract class DatabaseStorage
implements IStorage {
    protected PlayerPoints plugin;
    protected static final String GET_POINTS = "SELECT points FROM playerpoints WHERE playername=?;";
    protected static final String GET_PLAYERS = "SELECT playername FROM playerpoints;";
    protected static final String INSERT_PLAYER = "INSERT INTO playerpoints (points,playername) VALUES(?,?);";
    protected static final String UPDATE_PLAYER = "UPDATE playerpoints SET points=? WHERE playername=?";
    protected static final String REMOVE_PLAYER = "DELETE playerpoints WHERE playername=?";

    public DatabaseStorage(PlayerPoints plugin) {
        this.plugin = plugin;
    }

    protected void cleanup(ResultSet result, PreparedStatement statement) {
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("cleanup()");
        }
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "SQLException on cleanup", e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "SQLException on cleanup", e);
            }
        }
    }
}

