/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.exports;

import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.RootConfig;
import org.black_ixx.playerpoints.storage.StorageType;
import org.black_ixx.playerpoints.storage.exports.MySQLExport;
import org.black_ixx.playerpoints.storage.exports.SQLiteExport;

public class Exporter {
    private PlayerPoints plugin;

    public Exporter(PlayerPoints plugin) {
        this.plugin = plugin;
    }

    public void checkExport() {
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.exportSQL) {
            this.exportSQL(config.exportSource);
            this.plugin.getConfig().set("mysql.export.use", (Object)false);
            this.plugin.saveConfig();
        }
    }

    private void exportSQL(StorageType source) {
        switch (source) {
            case MYSQL: {
                MySQLExport mysql = new MySQLExport(this.plugin);
                mysql.doExport();
                break;
            }
            case SQLITE: {
                SQLiteExport sqlite = new SQLiteExport(this.plugin);
                sqlite.doExport();
            }
        }
    }
}

